/*
 * $Id: st-statusbar.c,v 1.16 2004/01/29 11:15:08 jylefort Exp $
 *
 * Copyright (c) 2002, 2003 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include <gtk/gtk.h>
#include "gettext.h"
#include "st-statusbar.h"
#include "sg-printable.h"

#define OFF_TIMEOUT			3000

/*** function declarations ***************************************************/

static void st_statusbar_init		(STStatusbar		*statusbar);
static void st_statusbar_printable_init	(SGPrintableIface	*iface);

static void st_statusbar_print		(SGPrintable		*printable,
					 const char		*str);

/*** implementation **********************************************************/

GType
st_statusbar_get_type (void)
{
  static GType statusbar_type = 0;
  
  if (! statusbar_type)
    {
      static const GTypeInfo statusbar_info = {
	sizeof(STStatusbarClass),
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	sizeof(STStatusbar),
	0,
	(GInstanceInitFunc) st_statusbar_init,
      };
      
      static const GInterfaceInfo printable_info = {
	(GInterfaceInitFunc) st_statusbar_printable_init,
	NULL,
	NULL
      };

      statusbar_type = g_type_register_static(GTK_TYPE_STATUSBAR,
					      "STStatusbar",
					      &statusbar_info,
					      0);
      g_type_add_interface_static(statusbar_type,
				  SG_TYPE_PRINTABLE,
				  &printable_info);
    }

  return statusbar_type;
}

static void
st_statusbar_init (STStatusbar *statusbar)
{
  GtkRequisition requisition;

  statusbar->progress_bar = gtk_progress_bar_new();
  statusbar->context = gtk_statusbar_get_context_id(GTK_STATUSBAR(statusbar), _("Main context"));

  /*
   * Set the height of the progressbar to the statusbar height, to
   * avoid resizing-flicker when hiding/showing the progressbar
   * (that'll shrink the progressbar if the statusbar height is
   * inferior to the progressbar height, and have no effect
   * otherwise).
   */
  gtk_widget_size_request(GTK_WIDGET(statusbar), &requisition);
  gtk_widget_set_size_request(GTK_WIDGET(statusbar->progress_bar),
			      -1,
			      requisition.height);

  gtk_box_pack_end(GTK_BOX(statusbar), statusbar->progress_bar, FALSE, FALSE, 0);

  gtk_statusbar_push(GTK_STATUSBAR(statusbar), statusbar->context,
		     PACKAGE " " VERSION " - " COPYRIGHT);
}

static void
st_statusbar_printable_init (SGPrintableIface *iface)
{
  iface->print = st_statusbar_print;
}

GtkWidget *
st_statusbar_new (void)
{
  return g_object_new(ST_TYPE_STATUSBAR, NULL);
}

static void
st_statusbar_print (SGPrintable *printable, const char *str)
{
  STStatusbar *statusbar = (STStatusbar *) printable;

  g_return_if_fail(ST_IS_STATUSBAR(statusbar));
  g_return_if_fail(str != NULL);

  gtk_statusbar_pop(GTK_STATUSBAR(statusbar), statusbar->context);
  gtk_statusbar_push(GTK_STATUSBAR(statusbar), statusbar->context, str);
}

void
st_statusbar_set_active (STStatusbar *statusbar, gboolean active)
{
  g_return_if_fail(ST_IS_STATUSBAR(statusbar));

  if (active)
    gtk_widget_show(statusbar->progress_bar);
  else
    {
      gtk_widget_hide(statusbar->progress_bar);
      gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(statusbar->progress_bar), 0);
    }
}
