/*
 * $Id: st-statusbar.h,v 1.11 2004/01/05 19:44:10 jylefort Exp $
 *
 * Copyright (c) 2002, 2003 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_STATUSBAR_H
#define _ST_STATUSBAR_H

#include <gtk/gtk.h>

#define ST_TYPE_STATUSBAR		(st_statusbar_get_type())
#define ST_STATUSBAR(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj), ST_TYPE_STATUSBAR, STStatusbar))
#define ST_STATUSBAR_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), ST_TYPE_STATUSBAR, STStatusbarClass))
#define ST_IS_STATUSBAR(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), ST_TYPE_STATUSBAR))
#define ST_IS_STATUSBAR_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), ST_TYPE_STATUSBAR))
#define ST_STATUSBAR_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), ST_TYPE_STATUSBAR, STStatusbarClass))

typedef struct
{
  GtkStatusbar		statusbar;

  GtkWidget		*progress_bar;	/* public */
  int			context;
} STStatusbar;

typedef struct
{
  GtkStatusbarClass	parent_class;
} STStatusbarClass;

GType		st_statusbar_get_type	(void);
GtkWidget	*st_statusbar_new	(void);
void		st_statusbar_set_active	(STStatusbar	*statusbar,
					 gboolean	active);

#endif /* _ST_STATUSBAR_H */
