/*
 * $Id: st-thread.h,v 1.18 2004/01/27 14:16:42 jylefort Exp $
 *
 * Copyright (c) 2002, 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_THREAD_H
#define _ST_THREAD_H

#include <gtk/gtk.h>
#include "sg-printable.h"
#include "st-handler.h"

typedef void	(STThreadCallback) (gpointer data);

typedef enum {
  ST_THREAD_TYPE_STREAM,
  ST_THREAD_TYPE_REFRESH
} STThreadType;
    
typedef struct
{
  STThreadType		type;

  STHandler		*handler;

  GtkWidget		*tab;			/* public */
  SGPrintable		*printable;		/* public */
  GtkWidget		*progress_bar;		/* public */

  gboolean		aborted;
  GMutex		*aborted_mutex;

  STThreadCallback	*cb;
  gpointer		data;

  unsigned int		downloaded; /* number of bytes downloaded so far */
  GTimer		*ui_timer; /* to not pulse the progress bar too often */
  gboolean		ui_first; /* are we at the first progress bar pulse */
} STThread;

void		st_thread_init		(void);
STThread	*st_thread_new		(STThreadType		type,
					 STHandler		*handler,
					 STThreadCallback	*cb,
					 gpointer		data);
void		st_thread_run		(STThread		*thread);
void		st_thread_abort		(STThread *thread);
gboolean	st_thread_is_aborted	(STThread *thread);
STThread	*st_thread_get		(void);

#endif /* _ST_THREAD_H */
