/*
 * $Id: st-toolbar.h,v 1.17 2004/01/27 14:16:42 jylefort Exp $
 *
 * Copyright (c) 2002, 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_TOOLBAR_H
#define _ST_TOOLBAR_H

#include <gtk/gtk.h>
#include "st-handler.h"

#define ST_TYPE_TOOLBAR			(st_toolbar_get_type())
#define ST_TOOLBAR(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), ST_TYPE_TOOLBAR, STToolbar))
#define ST_TOOLBAR_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), ST_TYPE_TOOLBAR, STToolbarClass))
#define ST_IS_TOOLBAR(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), ST_TYPE_TOOLBAR))
#define ST_IS_TOOLBAR_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), ST_TYPE_TOOLBAR))
#define ST_TOOLBAR_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), ST_TYPE_TOOLBAR, STToolbarClass))

typedef enum
{
  ST_TOOLBAR_STYLE_GTK = -1
} STToolbarStyle;

typedef enum
{
  ST_TOOLBAR_SIZE_GTK = -1
} STToolbarSize;

typedef struct
{
  GtkToolbar		toolbar;

  GtkWidget		*tune_in;
  GtkWidget		*record;
  GtkWidget		*browse;
  GtkWidget		*stop;
  GtkWidget		*refresh;

  STHandler		*handler;
  GtkWidget		*handler_link;
} STToolbar;

typedef struct
{
  GtkToolbarClass	parent_class;
} STToolbarClass;

GType		st_toolbar_get_type		(void);
GtkWidget	*st_toolbar_new			(void);
void		st_toolbar_update_sensitivity	(STToolbar	*toolbar);
void		st_toolbar_set_style		(STToolbar	*toolbar,
						 STToolbarStyle	style);
void		st_toolbar_set_size		(STToolbar	*toolbar,
						 STToolbarSize	size);
void		st_toolbar_set_handler		(STToolbar	*toolbar,
						 STHandler	*handler);

#endif /* _ST_TOOLBAR_H */
