/*
 * $Id: st-stock.c,v 1.35 2004/03/24 16:34:06 jylefort Exp $
 *
 * Copyright (c) 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include "gettext.h"
#include "art/add_bookmark.h"
#include "art/tune_in.h"
#include "art/record.h"
#include "art/browse.h"
#include "art/search.h"
#include "art/category.h"
#include "art/category_open.h"
#include "st-stock.h"

/*** constant definitions ****************************************************/

static const GtkStockItem items[] = {
  { ST_STOCK_TUNE_IN,			N_("_Tune in"),		0, 0,	NULL },
  { ST_STOCK_RECORD,			N_("_Record"),		0, 0,	NULL },
  { ST_STOCK_BROWSE,			N_("_Browse"),		0, 0,	NULL },
  
  { ST_STOCK_QUIT_WITHOUT_SAVING,	N_("_Quit Without Saving"),	0, 0, NULL },
  { ST_STOCK_OPEN_LINK,			N_("_Open Link"),	0, 0,	NULL },
  { ST_STOCK_COPY_LINK_ADDRESS,		N_("_Copy Link Address"),	0, 0, NULL },

  { ST_STOCK_NEW_PRESELECTION,		N_("_New Preselection"), 0, 0,	NULL },
  { ST_STOCK_ADD_BOOKMARK,		N_("_Add Bookmark"),	0, 0,	NULL }
};

/*** implementation **********************************************************/

void
st_stock_init (void)
{
  GtkIconFactory *factory;
  int i;

  const struct
  {
    const char		*stock_id;	/* the stock image to create	*/

    const char		*stock_image;	/*	the stock icon to use	*/
    const guint8	*data;		/* OR	some inline data...	*/
    int			size;		/*	...and its size		*/
  } icons[] = {
    { ST_STOCK_TUNE_IN,		NULL, art_tune_in, sizeof(art_tune_in) },
    { ST_STOCK_RECORD,		NULL, art_record, sizeof(art_record) },
    { ST_STOCK_BROWSE,		NULL, art_browse, sizeof(art_browse) },
    { ST_STOCK_QUIT_WITHOUT_SAVING,	GTK_STOCK_QUIT, NULL, 0 },
    { ST_STOCK_SEARCH,		NULL, art_search, sizeof(art_search) },
    { ST_STOCK_OPEN_LINK,		GTK_STOCK_OPEN, NULL, 0 },
    { ST_STOCK_COPY_LINK_ADDRESS,	GTK_STOCK_COPY, NULL, 0 },
    { ST_STOCK_NEW_PRESELECTION,	GTK_STOCK_NEW, NULL, 0 },
    { ST_STOCK_ADD_BOOKMARK,	NULL, art_add_bookmark, sizeof(art_add_bookmark) },
    { ST_STOCK_CATEGORY,	NULL, art_category, sizeof(art_category) },
    { ST_STOCK_CATEGORY_OPEN,	NULL, art_category_open, sizeof(art_category_open) }
  };
  
  factory = gtk_icon_factory_new();
  gtk_icon_factory_add_default(factory);

  for (i = 0; i < G_N_ELEMENTS(icons); i++)
    {
      GtkIconSet *icon_set;

      if (icons[i].stock_image)
	{
	  icon_set = gtk_icon_factory_lookup_default(icons[i].stock_image);
	  gtk_icon_set_ref(icon_set);
	}
      else
	{
	  GdkPixbuf *pixbuf;

	  pixbuf = gdk_pixbuf_new_from_inline(icons[i].size,
					      icons[i].data,
					      FALSE,
					      NULL);
	  icon_set = gtk_icon_set_new_from_pixbuf(pixbuf);
	  g_object_unref(pixbuf);
	}
      
      gtk_icon_factory_add(factory, icons[i].stock_id, icon_set);
      gtk_icon_set_unref(icon_set);
    }

  g_object_unref(factory);
  gtk_stock_add_static(items, G_N_ELEMENTS(items));
}
