/*
 * $Id: st-programs.c,v 1.9.4.1 2004/05/11 10:54:35 jylefort Exp $
 *
 * Copyright (c) 2002, 2003 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include <glib.h>
#include <glib/gi18n-lib.h>
#include "sg-util.h"
#include "st-thread.h"
#include "st-action.h"
#include "st-plugin.h"

/*** API implementation ******************************************************/

/*
 * Deprecated.
 */
void
st_programs_register (const char *action, const char *command)
{
  char *label;
  char *new_command;

  g_return_if_fail(action != NULL);
  g_return_if_fail(command != NULL);

  label = st_plugin_current
    ? g_strdup_printf(_("%s (deprecated, used by %s)"), action, st_plugin_current)
    : g_strdup_printf(_("%s (deprecated)"), action);
  
  new_command = st_action_convert_old_style_command(command);

  st_action_register(action, label, new_command);

  g_free(label);
  g_free(new_command);
}

/*
 * Deprecated.
 */
gboolean
st_programs_run (const char *action, const char *locator, GError **err)
{
  g_return_val_if_fail(action != NULL, FALSE);
  g_return_val_if_fail(locator != NULL, FALSE);

  return st_action_run(action, locator, err);
}
