/*
 * $Id: st-splash.c,v 1.3.2.2 2004/05/11 15:40:42 jylefort Exp $
 *
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include <gtk/gtk.h>
#include "art/streamtuner.h"
#include "gettext.h"
#include "sgtk-hig.h"
#include "st-splash.h"
#include "st-util.h"

/*** type definitions ********************************************************/

struct _STSplashPrivate
{
  GtkWidget	*label;
  GtkWidget	*progress_bar;
};

/*** variable declarations ***************************************************/

static GObjectClass *parent_class = NULL;

/*** function declarations ***************************************************/

static void st_splash_class_init (STSplashClass *class);
static void st_splash_init (STSplash *splash);
static void st_splash_finalize (GObject *object);

/*** implementation **********************************************************/

GType
st_splash_get_type (void)
{
  static GType splash_type = 0;
  
  if (! splash_type)
    {
      static const GTypeInfo splash_info = {
	sizeof(STSplashClass),
	NULL,
	NULL,
	(GClassInitFunc) st_splash_class_init,
	NULL,
	NULL,
	sizeof(STSplash),
	0,
	(GInstanceInitFunc) st_splash_init,
      };
      
      splash_type = g_type_register_static(GTK_TYPE_WINDOW,
					  "STSplash",
					   &splash_info,
					   0);
    }
  
  return splash_type;
}

static void
st_splash_class_init (STSplashClass *class)
{
  GObjectClass *object_class = G_OBJECT_CLASS(class);

  parent_class = g_type_class_peek_parent(class);

  object_class->finalize = st_splash_finalize;
}

static void
st_splash_init (STSplash *splash)
{
  GdkPixbuf *icon;
  GtkWidget *logo;
  GtkWidget *vbox;
  GtkWidget *frame;

  splash->priv = g_new0(STSplashPrivate, 1);
  
  icon = gdk_pixbuf_new_from_inline(sizeof(art_streamtuner),
				    art_streamtuner,
				    FALSE,
				    NULL);
  gtk_window_set_icon(GTK_WINDOW(splash), icon);
  g_object_unref(icon);

  gtk_window_set_title(GTK_WINDOW(splash), NULL);
  gtk_window_set_resizable(GTK_WINDOW(splash), FALSE);
  gtk_window_set_decorated(GTK_WINDOW(splash), FALSE);
  gtk_window_set_type_hint(GTK_WINDOW(splash), GDK_WINDOW_TYPE_HINT_SPLASHSCREEN);
  gtk_window_set_position(GTK_WINDOW(splash), GTK_WIN_POS_CENTER);

  logo = st_logo_new();
  splash->priv->label = gtk_label_new(_("Initializing..."));
  splash->priv->progress_bar = gtk_progress_bar_new();
  
  vbox = gtk_vbox_new(FALSE, SGTK_HIG_UNIT);
  gtk_container_set_border_width(GTK_CONTAINER(vbox), SGTK_HIG_UNIT);

  gtk_box_pack_start(GTK_BOX(vbox), logo, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), splash->priv->label, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), splash->priv->progress_bar, FALSE, FALSE, 0);

  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);

  gtk_container_add(GTK_CONTAINER(frame), vbox);
  gtk_container_add(GTK_CONTAINER(splash), frame);
  gtk_widget_show_all(frame);
}

static void
st_splash_finalize (GObject *object)
{
  STSplash *splash = ST_SPLASH(object);

  g_free(splash->priv);

  G_OBJECT_CLASS(parent_class)->finalize(object);
}

GtkWidget *
st_splash_new (void)
{
  return g_object_new(ST_TYPE_SPLASH, NULL);
}

void
st_splash_set_text (STSplash *splash, const char *str)
{
  g_return_if_fail(ST_IS_SPLASH(splash));
  g_return_if_fail(str != NULL);

  gtk_label_set_text(GTK_LABEL(splash->priv->label), str);
}

void
st_splash_set_progress (STSplash *splash, double progress)
{
  g_return_if_fail(ST_IS_SPLASH(splash));

  gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(splash->priv->progress_bar), progress);
}
