/*
 * $Id: st-category-store.h,v 1.11.2.1 2004/08/09 12:35:57 jylefort Exp $
 *
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_CATEGORY_STORE_H
#define _ST_CATEGORY_STORE_H

#include <gtk/gtk.h>
#include "st-category-bag.h"
#include "st-handler-api.h"

#define ST_TYPE_CATEGORY_STORE			(st_category_store_get_type())
#define ST_CATEGORY_STORE(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), ST_TYPE_CATEGORY_STORE, STCategoryStore))
#define ST_CATEGORY_STORE_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), ST_TYPE_CATEGORY_STORE, STCategoryStoreClass))
#define ST_IS_CATEGORY_STORE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), ST_TYPE_CATEGORY_STORE))
#define ST_IS_CATEGORY_STORE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), ST_TYPE_CATEGORY_STORE))
#define ST_CATEGORY_STORE_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), ST_TYPE_CATEGORY_STORE, STCategoryStoreClass))

enum {
  ST_CATEGORY_STORE_COLUMN_BAG,
  ST_CATEGORY_STORE_COLUMN_STOCK_ID,
  ST_CATEGORY_STORE_COLUMN_LABEL,
  ST_CATEGORY_STORE_N_COLUMNS
};

typedef struct _STCategoryStorePrivate STCategoryStorePrivate;

typedef struct
{
  GtkTreeStore			store;

  STCategoryStorePrivate	*priv;
} STCategoryStore;

typedef struct
{
  GtkTreeStoreClass		parent_class;

  /* signals */
  void (*category_appended) (STCategoryStore *store, STCategoryBag *bag);
} STCategoryStoreClass;

typedef gboolean (STCategoryStoreForeachCallback) (STCategoryStore *store,
						   STCategoryBag *bag,
						   STCategoryBag *parent,
						   gpointer data);

GType		st_category_store_get_type	(void);
STCategoryStore	*st_category_store_new		(GNode *stock_categories);

void		st_category_store_append	(STCategoryStore  *store,
						 STCategoryBag    *bag,
						 STCategoryBag    *parent);
void		st_category_store_append_node	(STCategoryStore  *store,
						 GNode            *node);
void		st_category_store_foreach	(STCategoryStore  *store,
						 STCategoryStoreForeachCallback *cb,
						 gpointer         data);
void		st_category_store_clear		(STCategoryStore  *store);

gboolean	st_category_store_search_equal_func (GtkTreeModel *model,
						     int          column,
						     const char   *key,
						     GtkTreeIter  *iter,
						     gpointer     search_data);

#endif /* _ST_CATEGORY_STORE_H */
