/*
 * $Id: st-shell.h,v 1.37.2.1 2004/08/05 13:01:50 jylefort Exp $
 *
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_SHELL_H
#define _ST_SHELL_H

#include <gtk/gtk.h>
#include "st-stream-bag.h"
#include "st-thread.h"

#define ST_TYPE_SHELL			(st_shell_get_type())
#define ST_SHELL(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), ST_TYPE_SHELL, STShell))
#define ST_SHELL_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), ST_TYPE_SHELL, STShellClass))
#define ST_IS_SHELL(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), ST_TYPE_SHELL))
#define ST_IS_SHELL_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), ST_TYPE_SHELL))
#define ST_SHELL_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), ST_TYPE_SHELL, STShellClass))

typedef struct _STShellPrivate STShellPrivate;

typedef struct
{
  GObject		object;

  STShellPrivate	*priv;
} STShell;

typedef struct
{
  GObjectClass		parent_class;
} STShellClass;

#define ST_SHELL_TOOLBAR_STYLE_GTK	-1
#define ST_SHELL_TOOLBAR_SIZE_GTK	-1

GType		st_shell_get_type			(void);

STShell		*st_shell_new				(void);

void		st_shell_show				(STShell   *shell);
void		st_shell_hide				(STShell   *shell);

void		st_shell_prepare_finalize		(STShell   *shell);

void		st_shell_update_title			(STShell   *shell);
void		st_shell_update_sensitivity		(STShell   *shell);

gboolean	st_shell_can_select_previous_stream	(STShell   *shell);
gboolean	st_shell_can_select_next_stream		(STShell   *shell);

gboolean	st_shell_can_tune_in			(STShell   *shell);
void		st_shell_tune_in			(STShell   *shell);

gboolean	st_shell_can_record			(STShell   *shell);
void		st_shell_record				(STShell   *shell);

gboolean	st_shell_can_browse			(STShell   *shell);
void		st_shell_browse				(STShell   *shell);

gboolean	st_shell_can_present_stream_properties	(STShell   *shell);
void		st_shell_present_stream_properties	(STShell   *shell);

gboolean	st_shell_can_add_bookmarks		(STShell   *shell);
void		st_shell_add_bookmarks			(STShell   *shell);

gboolean	st_shell_can_delete_streams		(STShell   *shell);
void		st_shell_delete_streams			(STShell   *shell);

void		st_shell_new_preselection		(STShell   *shell);

void		st_shell_add_stream_task		(STShell   *shell,
							 STThread  *thread,
							 gboolean  tune_in);
void		st_shell_remove_stream_task		(STShell   *shell,
							 STThread  *thread);

GtkWindow	*st_shell_get_transient			(STShell   *shell);

#endif /* _ST_SHELL_H */
