/*
 * $Id: st-version-api.h,v 1.15.2.5 2004/08/09 13:22:07 jylefort Exp $
 *
 * Copyright (c) 2002, 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_VERSION_API_H
#define _ST_VERSION_API_H

#include <glib.h>

#define ST_MAJOR_VERSION		0
#define ST_MINOR_VERSION		12
#define ST_MICRO_VERSION		5

/*
 * ST_API_MAJOR_VERSION is bumped when a change in the API breaks
 * backwards compatibility.
 *
 * ST_API_MINOR_VERSION is bumped when new API features are introduced
 * while preserving backwards compatibility.
 */

#define ST_API_MAJOR_VERSION		5
#define ST_API_MINOR_VERSION		6

extern const unsigned int st_major_version;
extern const unsigned int st_minor_version;
extern const unsigned int st_micro_version;

extern const unsigned int st_api_major_version;
extern const unsigned int st_api_minor_version;

gboolean st_check_api_version (unsigned int required_major_version,
			       unsigned int minimum_minor_version);

#endif /* _ST_VERSION_API_H */
