# $Id: acinclude.m4,v 1.23.2.5 2004/10/22 01:14:04 jylefort Exp $
#
# Copyright (c) 2002, 2003, 2004 Jean-Yves Lefort.
#
# This file is part of streamtuner.
# It may be distributed under the same terms as streamtuner.

### feature handling ##########################################################

dnl ST_FEATURE_VAR_NAME(FEATURE)
dnl
AC_DEFUN([ST_FEATURE_VAR_NAME], [enable_[]translit([$1], -, _)])

dnl ST_FEATURE_DISABLE_REASON_VAR_NAME(FEATURE)
dnl
AC_DEFUN([ST_FEATURE_DISABLE_REASON_VAR_NAME], [disable_[]translit([$1], -, _)_reason])

dnl ST_FEATURE_SYMBOL_NAME(FEATURE)
dnl
AC_DEFUN([ST_FEATURE_SYMBOL_NAME], [WITH_[]translit([$1], -a-z, _A-Z)])

dnl ST_FEATURE_ENABLED(FEATURE)
dnl
AC_DEFUN([ST_FEATURE_ENABLED], [test $ST_FEATURE_VAR_NAME([$1]) = yes])

dnl ST_FEATURE_DISABLED(FEATURE)
dnl
AC_DEFUN([ST_FEATURE_DISABLED], [test $ST_FEATURE_VAR_NAME([$1]) = no])

dnl ST_FEATURE_DISABLE(FEATURE, REPORT_REASON, [NOTICE_REASON])
dnl
AC_DEFUN([ST_FEATURE_DISABLE],
[AC_MSG_NOTICE([ifelse([$3],, [$2], [$3]): forcing --disable-[$1]])
ST_FEATURE_VAR_NAME([$1])=no
ST_FEATURE_DISABLE_REASON_VAR_NAME([$1])="([$2])"])

dnl ST_FEATURE_DEFINE(FEATURE)
dnl
AC_DEFUN([ST_FEATURE_DEFINE],
[if ST_FEATURE_ENABLED([$1]); then
	AC_DEFINE(ST_FEATURE_SYMBOL_NAME([$1]), 1, [Define to 1 if [$1] is enabled])
fi
])

dnl ST_FEATURES_DEFINE(FEATURES)
dnl
AC_DEFUN([ST_FEATURES_DEFINE], [m4_foreach(feature, [$1], [ST_FEATURE_DEFINE(feature)])])

### command line arguments ####################################################

dnl ST_ARG_ENABLE(FEATURE, DESCRIPTION, [DEFAULT])
dnl
AC_DEFUN([ST_ARG_ENABLE],
[AC_ARG_ENABLE([$1],
AS_HELP_STRING(--ifelse([$3], no, enable, disable)-[$1], $2),
[case "$enableval" in
	yes|no) ST_FEATURE_VAR_NAME([$1])=$enableval ;;
	*) AC_MSG_ERROR([bad value $enableval for --enable-[$1]]) ;;
esac], [ST_FEATURE_VAR_NAME([$1])=ifelse([$3],, yes, [$3])])])

dnl ST_ARG_COMPILE_WARNINGS
dnl
AC_DEFUN([ST_ARG_COMPILE_WARNINGS],
[AC_ARG_ENABLE(compile-warnings,
AC_HELP_STRING([--enable-compile-warnings=no|yes|error],
[enable compiler warnings [[no]]]),
[case "$enableval" in
	yes|no|error) enable_compile_warnings=$enableval ;;
	*) AC_MSG_ERROR([bad value $enableval for --enable-compile-warnings]) ;;
esac], [enable_compile_warnings=no])

if test $enable_compile_warnings = no; then
	WARN_CFLAGS=
else
	# some flags are specific to GCC
	WARN_CFLAGS="-Wall -Wcast-align -Wredundant-decls -Wnested-externs -Winline"
	test $enable_compile_warnings = error && WARN_CFLAGS="$WARN_CFLAGS -Werror"
fi

AC_SUBST(WARN_CFLAGS)])

### report ####################################################################

dnl ST_REPORT(NAME, VALUE)
dnl
AC_DEFUN([ST_REPORT], [  m4_format([%-30s %s], [$1], [$2])])

dnl ST_REPORT_ARG(NAME)
dnl
AC_DEFUN([ST_REPORT_ARG], [ST_REPORT([--[$1]], [$translit([$1], -, _)])])

dnl ST_REPORT_ARGS(NAMES)
dnl
AC_DEFUN([ST_REPORT_ARGS], [m4_foreach(name, [$1], [ST_REPORT_ARG(name)
])])

dnl ST_REPORT_FEATURE(FEATURE)
dnl
AC_DEFUN([ST_REPORT_FEATURE],
[ST_REPORT([--enable-[$1]],
[$ST_FEATURE_VAR_NAME([$1]) $ST_FEATURE_DISABLE_REASON_VAR_NAME([$1])])])

dnl ST_REPORT_FEATURES(FEATURES)
dnl
AC_DEFUN([ST_REPORT_FEATURES], [m4_foreach(feature, [$1], [ST_REPORT_FEATURE(feature)
])])
