/*
 * Copyright (c) 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _SGTK_UTIL_H
#define _SGTK_UTIL_H

#include <gtk/gtk.h>

typedef enum
{
  SGTK_RESPONSE_PREVIOUS,
  SGTK_RESPONSE_NEXT
} sGtkResponseType;

typedef enum
{
  SGTK_PREVIOUS,
  SGTK_NEXT
} sGtkDirection;

void		sgtk_flush			(void);
char		*sgtk_translate_func		(const char	*path,
						 gpointer	data);
GdkPixbuf	*sgtk_pixbuf_scale		(GdkPixbuf	*pixbuf,
						 GtkIconSize	size);
void		sgtk_widget_set_next_widget	(GtkWidget	*widget,
						 GtkWidget	*next);
void		sgtk_widget_set_popup_menu	(GtkWidget	*widget,
						 GtkMenu	*menu);
void		sgtk_tree_model_make_countable	(GtkTreeModel	*model);
gboolean	sgtk_tree_model_is_countable	(GtkTreeModel	*model);
unsigned int	sgtk_tree_model_get_count	(GtkTreeModel	*model);
gboolean	sgtk_tree_model_get_iter_last	(GtkTreeModel	*model,
						 GtkTreeIter	*iter);
gboolean	sgtk_tree_model_iter_prev	(GtkTreeModel	*model,
						 GtkTreeIter	*iter);
gboolean	sgtk_tree_model_iter_move	(GtkTreeModel	*model,
						 GtkTreeIter	*iter,
						 sGtkDirection	direction);
void		sgtk_accel_map_add_entry	(const char	*accel_path,
						 const char	*accelerator);
gboolean	sgtk_accel_map_change_entry	(const char	*accel_path,
						 const char	*accelerator,
						 gboolean	replace);
void		sgtk_window_link_size		(GtkWindow	*window,
						 int		*width,
						 int		*height);

#endif /* _SGTK_UTIL_H */
