/*
 * Copyright (c) 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <gtk/gtk.h>
#include "st-stock.h"
#include "st-stream-menu-items.h"
#include "st-shell.h"

/*** type definitions ********************************************************/

struct _STStreamMenuItems
{
  STShell	*shell;
  GtkWidget	*tune_in;
  GtkWidget	*record;
  GtkWidget	*browse;
  GtkWidget	*separator1;
  GtkWidget	*add_bookmark;
  GtkWidget	*delete;
  GtkWidget	*separator2;
  GtkWidget	*properties;
};

/*** implementation **********************************************************/

STStreamMenuItems *
st_stream_menu_items_new (STShell *shell, GtkAccelGroup *accel_group)
{
  STStreamMenuItems *items;

  items = g_new(STStreamMenuItems, 1);

  items->shell = shell;
  items->tune_in = gtk_image_menu_item_new_from_stock(ST_STOCK_TUNE_IN, accel_group);
  items->record = gtk_image_menu_item_new_from_stock(ST_STOCK_RECORD, accel_group);
  items->browse = gtk_image_menu_item_new_from_stock(ST_STOCK_BROWSE, accel_group);
  items->separator1 = gtk_separator_menu_item_new();
  items->add_bookmark = gtk_image_menu_item_new_from_stock(ST_STOCK_ADD_BOOKMARK, accel_group);
  items->delete = gtk_image_menu_item_new_from_stock(GTK_STOCK_DELETE, accel_group);
  items->separator2 = gtk_separator_menu_item_new();
  items->properties = gtk_image_menu_item_new_from_stock(GTK_STOCK_PROPERTIES, accel_group);
  
  g_signal_connect_swapped(items->tune_in,
			   "activate",
			   G_CALLBACK(st_shell_tune_in),
			   items->shell);
  g_signal_connect_swapped(items->record,
			   "activate",
			   G_CALLBACK(st_shell_record),
			   items->shell);
  g_signal_connect_swapped(items->browse,
			   "activate",
			   G_CALLBACK(st_shell_browse),
			   items->shell);
  g_signal_connect_swapped(items->add_bookmark,
			   "activate",
			   G_CALLBACK(st_shell_add_bookmarks),
			   items->shell);
  g_signal_connect_swapped(items->delete,
			   "activate",
			   G_CALLBACK(st_shell_delete_streams),
			   items->shell);
  g_signal_connect_swapped(items->properties,
			   "activate",
			   G_CALLBACK(st_shell_present_stream_properties),
			   items->shell);

  gtk_widget_show(items->tune_in);
  gtk_widget_show(items->record);
  gtk_widget_show(items->browse);
  gtk_widget_show(items->separator1);
  gtk_widget_show(items->add_bookmark);
  gtk_widget_show(items->delete);
  gtk_widget_show(items->separator2);
  gtk_widget_show(items->properties);

  return items;
}

void
st_stream_menu_items_free (STStreamMenuItems *items)
{
  g_return_if_fail(items != NULL);

  g_free(items);
}

void
st_stream_menu_items_update_sensitivity (STStreamMenuItems *items)
{
  g_return_if_fail(items != NULL);

  gtk_widget_set_sensitive(items->tune_in, st_shell_can_tune_in(items->shell));
  gtk_widget_set_sensitive(items->record, st_shell_can_record(items->shell));
  gtk_widget_set_sensitive(items->browse, st_shell_can_browse(items->shell));
  gtk_widget_set_sensitive(items->add_bookmark, st_shell_can_add_bookmarks(items->shell));
  gtk_widget_set_sensitive(items->delete, st_shell_can_delete_streams(items->shell));
  gtk_widget_set_sensitive(items->properties, st_shell_can_present_stream_properties(items->shell));
}

void
st_stream_menu_items_insert_into_shell (STStreamMenuItems *items,
					GtkMenuShell *menu_shell,
					int position)
{
  g_return_if_fail(items != NULL);
  g_return_if_fail(GTK_IS_MENU_SHELL(menu_shell));
  
  gtk_menu_shell_insert(menu_shell, items->tune_in, position++);
  gtk_menu_shell_insert(menu_shell, items->record, position++);
  gtk_menu_shell_insert(menu_shell, items->browse, position++);
  gtk_menu_shell_insert(menu_shell, items->separator1, position++);
  gtk_menu_shell_insert(menu_shell, items->add_bookmark, position++);
  gtk_menu_shell_insert(menu_shell, items->delete, position++);
  gtk_menu_shell_insert(menu_shell, items->separator2, position++);
  gtk_menu_shell_insert(menu_shell, items->properties, position++);
}
