/*
 * $Id: pst-category-node.c,v 1.15 2004/03/28 22:41:18 jylefort Exp $
 *
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <Python.h>
#include "pst-category-node.h"
#include "pst-category.h"
#include "pst-helpers.h"

/*** methods *****************************************************************/

static PyObject *pst_category_node_append (PSTCategoryNode *self, PyObject *args);

static PyMethodDef methods[] = {
  { "append", (PyCFunction) pst_category_node_append, METH_VARARGS },
  
  { NULL }
};

/*** type object *************************************************************/

static PyObject *pst_category_node_new (PyTypeObject *type, PyObject *args, PyObject *keywords);
static void pst_category_node_dealloc (PSTCategoryNode *self);

PyTypeObject PSTCategoryNode_Type = {
  PyObject_HEAD_INIT(NULL)
  0,				/* ob_size */
  "ST.CategoryNode",		/* tp_name */
  sizeof(PSTCategoryNode),	/* tp_basicsize */
  0,				/* tp_itemsize */
  (destructor) pst_category_node_dealloc, /* tp_dealloc */
  NULL,				/* tp_print */
  NULL,				/* tp_getattr */
  NULL,				/* tp_setattr */
  NULL,				/* tp_compare */
  NULL,				/* tp_repr */
  NULL,				/* tp_as_number */
  NULL,				/* tp_as_sequence */
  NULL,				/* tp_as_mapping */
  NULL,				/* tp_hash */
  NULL,				/* tp_call */
  NULL,				/* tp_str */
  NULL,				/* tp_getattro */
  NULL,				/* tp_setattro */
  NULL,				/* tp_as_buffer */
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
  NULL,				/* tp_doc */
  NULL,				/* tp_traverse */
  NULL,				/* tp_clear */
  NULL,				/* tp_richcompare */
  0,				/* tp_weaklistoffset */
  NULL,				/* tp_iter */
  NULL,				/* tp_iternext */
  methods,			/* tp_methods */
  NULL,				/* tp_members */
  NULL,				/* tp_getset */
  NULL,				/* tp_base */
  NULL,				/* tp_dict */
  NULL,				/* tp_descr_get */
  NULL,				/* tp_descr_set */
  0,				/* tp_dictoffset */
  NULL,				/* tp_init */
  NULL,				/* tp_alloc */
  pst_category_node_new		/* tp_new */
};

/*** function declarations ***************************************************/

static void pst_category_node_construct (PSTCategoryNode *self, PSTCategory *p);
static gboolean pst_category_node_dealloc_cb (GNode *node, gpointer data);

static gboolean PSTCategoryNode_AsNode_cb (GNode *node, gpointer data);

/*** type methods ************************************************************/

static PyObject *
pst_category_node_new (PyTypeObject *type, PyObject *args, PyObject *keywords)
{
  static char *keyword_list[] = { "category", NULL };
  PSTCategoryNode *self;
  PSTCategory *pcategory = NULL;

  if (! PyArg_ParseTupleAndKeywords(args, keywords, "|O!", keyword_list,
				    &PSTCategory_Type, &pcategory))
    return NULL;

  self = (PSTCategoryNode *) type->tp_alloc(type, 0);
  pst_category_node_construct(self, pcategory);

  return (PyObject *) self;
}

static void
pst_category_node_construct (PSTCategoryNode *self, PSTCategory *p)
{
  Py_XINCREF(p);
  self->node = g_node_new(p);
}

static void
pst_category_node_dealloc (PSTCategoryNode *self)
{
  g_node_traverse(self->node,
		  G_PRE_ORDER,
		  G_TRAVERSE_ALL,
		  -1,
		  pst_category_node_dealloc_cb,
		  NULL);
  g_node_destroy(self->node);

  self->ob_type->tp_free((PyObject *) self);
}

static gboolean
pst_category_node_dealloc_cb (GNode *node, gpointer data)
{
  Py_XDECREF((PyObject *) node->data);
  return FALSE;			/* continue */
}

/*** object methods **********************************************************/

static PyObject *
pst_category_node_append (PSTCategoryNode *self, PyObject *args)
{
  PSTCategoryNode *pnode;

  if (! PyArg_ParseTuple(args, "O!", &PSTCategoryNode_Type, &pnode))
    return NULL;

  Py_XINCREF((PyObject *) pnode->node->data);
  g_node_append(self->node, g_node_copy(pnode->node));

  return pst_none();
}

/*** C API *******************************************************************/

gboolean
pst_category_node_register (PyObject *module)
{
  g_return_val_if_fail(module != NULL, FALSE);

  if (PyType_Ready(&PSTCategoryNode_Type) < 0)
    return FALSE;

  Py_INCREF(&PSTCategoryNode_Type);
  PyModule_AddObject(module, "CategoryNode", (PyObject *) &PSTCategoryNode_Type);

  return TRUE;
}

GNode *
PSTCategoryNode_AsNode (PSTCategoryNode *self)
{
  GNode *node;

  g_return_val_if_fail(self != NULL, NULL);

  node = g_node_copy(self->node);
  g_node_traverse(node,
		  G_PRE_ORDER,
		  G_TRAVERSE_ALL,
		  -1,
		  PSTCategoryNode_AsNode_cb,
		  NULL);

  return node;
}

static gboolean
PSTCategoryNode_AsNode_cb (GNode *node, gpointer data)
{
  PSTCategory *p = node->data;

  if (p)
    node->data = pst_category_copy(p->category);

  return FALSE;			/* continue */
}
