// Paul Johnson  Dec. 28, 2000.  This class facilitates creation of
// a scatter plot.  The aim 
// is to minimize the amount of user-editing required. That is done by
// passing in all needed labels/collection/range information in the
// constructor.  Then, the method to update/redraw is called "update",
// as in the standard Swarm graph.


import java.util.Iterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ArrayList;

import java.awt.Color;
import javax.swing.JFrame;

import swarm.Globals;

import ptolemy.plot.Plot;
public class AttendanceScatterPlot extends Plot {
  Bar theBar;
  private JFrame myFrame = null;
  public AttendanceScatterPlot (String title, Bar barInput, 
				String xLabel,
				String yLabel, double xRange, double yRange) {
    myFrame = new JFrame();
    setTitle(title);
    myFrame.setTitle(title);
       
    setXRange(0,xRange);
    setYRange(0,yRange);
    _xTop = (double)xRange;
    _yTop = (double)yRange;
    setXLog(true);
    setYLog(true);
    setMarksStyle("dots");
    setXLabel(xLabel);
    setYLabel(yLabel);
    setButtons(true);

    setPointsPersistence(20);
    myFrame.setSize(400,300);
    myFrame.getContentPane().add(this);
    myFrame.show();
    theBar = barInput;
  }
   
  public synchronized Object update() {
        
  
    boolean needRepaint = false;
    double newPointX, newPointY;
       
    newPointX = theBar.getAttendanceLag(1);

    newPointY = theBar.getAttendanceLag(0);


    System.out.println("Br attendance " + newPointX + " now " + newPointY);
	
    //  	    if (newPointX > _xTop+0.0) {
    //                  setXRange(0,newPointX+5);
    //                  needRepaint = true;
    //              }


	
    //  	    if (newPointY > _yTop+0.0) {
    //  		setYRange(0,newPointY+5);
    //  		needRepaint = true;
    //              }
           
    addPoint(0,newPointX,newPointY,true);
	   
	   
     
    if (needRepaint)    repaint();

    return this;
  }

  public void drop() {
        
    myFrame.dispose();
  }

}












