

import swarm.objectbase.Swarm;
import swarm.objectbase.SwarmImpl;
import swarm.Globals;
import swarm.defobj.Zone;

import swarm.activity.Activity;
import swarm.activity.ActionGroup;
import swarm.activity.ActionGroupImpl;
import swarm.activity.Schedule;
import swarm.activity.ScheduleImpl;
import swarm.Selector;

import java.util.List;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;



public class ModelSwarm extends SwarmImpl {
	public static int aClassVar = 19;
    int numRules = 21; 
    int numAgents;
    char[] reportFileName;
    //  FILE *reportFILE;
    ArrayList agents;
    HashMap rules;
    Bar theBar;
  
    //  public ActionGroup modelActions;
    public Schedule   modelSchedule;
    
    MyParameter arguments;

    public ModelSwarm (Zone aZone, MyParameter args){
	super(aZone);
	arguments = args;
	reportFileName = new char[50];
	
    }



////////////////////////////////////////////////////////////////////
// This will find an agent with the specified ID.
// returns nil if not found.

    public Agent findAgentWithID (int ID){
	Iterator iterator = agents.iterator();
	Agent anAgent = null ;
	while (iterator.hasNext()){
	    anAgent = (Agent) iterator.next();
	    if ( ID == anAgent.getID() )
		break;
	}
	return anAgent;
    }


    public Object buildObjects () {
	int i, Act;
	numAgents = arguments.numAgents;
	int startAtt = arguments.startAttendance;
	int numAct = arguments.numActive; //numActive
	int memory = arguments.historyLength; // historyLength ;
	Agent anAgent;
	Rule aRule;

	theBar = new Bar ( memory );
	theBar.setStartAttendance ( startAtt );
	//	theBar.setModelSwarm (this);

	rules = new HashMap ( numRules );
	for (i = 0; i < numRules; i++){
	    aRule = new Rule (i);
	    aRule.setTheBar (theBar);
	    aRule.setTotalAgents (numAgents);
	    rules.put(new Integer(i), aRule);
	}

	theBar.setRules (rules);

	agents = new ArrayList (numAgents);

	for (i = 0; i < numAgents; i++){
	    anAgent = new Agent (i, rules, numAct);
	    anAgent.setTheBar (theBar);
	    anAgent.initStrats();
	    anAgent.setMemoryLen (memory);
	    anAgent.setTotalAgents (numAgents);
	    agents.add(anAgent);
	}

	return this;
    }
   

    //-(FILE *) getReportFile { return reportFILE; }

    public void stepAgents (){
	int x;
	Iterator iterator = agents.listIterator(0);
	Agent anAgent = null ;

	while (iterator.hasNext()){
  	    anAgent = (Agent) iterator.next();
  	    x = anAgent.makeChoice();
	}  
	//previous is same as:
//  	for ( i = 0; i < numAgents; i++){
//  	    anAgent = (Agent) agents.get(i);
//  	    System.out.println("ModelStep agent i = " + i);
//  	    x = anAgent.makeChoice();
//   	    anAgent.sayHi();
//    	    System.out.println("Agent List Size= " + agents.size() + " Agent" + anAgent.getID() + " says " + x);
//  	}

	Iterator iterator2 = agents.listIterator(0);
	while (iterator2.hasNext()){
	    anAgent = (Agent) iterator2.next();
	    anAgent.updateStrategies();
	}  
    }  


    public Object buildActions (){

	super.buildActions ();
	
	ActionGroup modelActions = new ActionGroupImpl(getZone());
	
	try {
	    modelActions.createActionTo$message
		(theBar, new Selector (theBar.getClass (), "startStep", false));
	} catch (Exception e) {
	    e.printStackTrace (System.err);
	    System.exit (1);
	}

	try {
	    modelActions.createActionTo$message 
		(this, new Selector (this.getClass (), "stepAgents", false));
	} catch (Exception e) {
	    e.printStackTrace (System.err);
	    System.exit (1);
	}
  
	try {
	    modelActions.createActionTo$message
		(theBar, new Selector (theBar.getClass (), "endStep", false));
	} catch (Exception e) {
	    e.printStackTrace (System.err);
	    System.exit (1);
	}
	//  modelActions.createActionTo$message 
	//  (this, new Selector (this.getClass (), "stepReport", false));


	modelSchedule = new ScheduleImpl (getZone(), 1);
	modelSchedule.at$createAction (0, modelActions);
	
	return this;
    }

    public Activity activateIn (Swarm swarmContext) {
  
	super.activateIn (swarmContext);
	System.out.println("modelSwarm activateIn"+modelSchedule.toString());
	modelSchedule.activateIn (this);
	return getActivity ();
    }



    //////////////////////////////////////////////////////////////////
    // stepReport
    // Print info to the reportFILE.

    //  -stepReport {
    //  //  	if ( getCurrentTime() % 1 == 0 ) {
    //  //  		fprintf( reportFILE,
    //  //  			 " %5lu %4d %7.2f\n", getCurrentTime(), 
    //  //  			 [theBar getAttendance], [theBar getRAvgAttendance] );
    //  //  	}
    //    fprintf(reportFILE, "%d    %7.2f\n", [theBar getAttendance],
    //  					       [theBar getRAvgAttendance]);
    //  	  fflush(reportFILE);
    //  	return self;
    //  }

    //  @end

    public List getAgents () {return agents;}
    public Bar getTheBar() {return theBar;}
    public HashMap getRules () {return rules;} 

}












