
public class MovingAverage {
    double lastInput;
    int width;
    int numInputs = 0;
    int arrayPosition = 0;
    double uncorrectedSum = 0;
    double[] maInputs; 
    double sumOfInputs;


    MovingAverage (int MAWidth){
   	width = MAWidth;
	maInputs = new double[MAWidth];//set to 0 automatically?
	}

    public int getNumInputs (){
	return numInputs;
    }

    //For get cycle, I choose to return the oldest recorded attendence when
    //repeatTime is too large.  For this purpose, repeatTime should not be
    //set higher than width, or this becomes meaningless.


    public double getCycle (int repeatTime){
	int index;
	index=repeatTime;
	if(numInputs < repeatTime)
	    {  
		index=numInputs-1;
		// printf("repeatTime higher than numInputs, set index at %d",index);
	    }else if(width < repeatTime) {
		index=width-1;
		//printf("uh-oh, repeatTime higher than width!! index set at %d", index);
	    }else{
		if(numInputs < width) { index = numInputs-repeatTime; }
		else{ index = width-repeatTime-1; }
	    }
	if((index < 0) || (index >= width)) {/*printf("error, index is %d",index)*/;} 
	return maInputs[index];

    
    }

    public double getMA (){
	double movingAverage;
	if (numInputs == 0) return 0;

	else if (numInputs < width)
	    {
		movingAverage=  (double)sumOfInputs / numInputs;
	    }
	else
	    {
		movingAverage = (double)sumOfInputs / width;
	    }
	//  printf( "Object: ma=%f  sumOfInput: %f numInputs: %d \n",movingAverage, sumOfInputs, numInputs);
	return movingAverage;
    }
  
    //This routine gets the "trend" over the past "num" numbers.
    //This is bounded by zero and max where max is the total number of agents.

    public double getTrendNumWithBound (int num, int max){
	double totalTrend=0;
	double returnValue=0.0;
	int start, stop, i;
	if(numInputs<1){ 
	    returnValue = 5;
	}else if(numInputs == 1) 
	    {returnValue = maInputs[0];
	    }else{ 
		if(numInputs < width) {
		    stop = numInputs;
		}else{
		    stop = width-1;
		}
		start=stop-num;
		if(start < 0) { 
		    start=0; 
		}
		for(i=(start+1); i<stop; i++) {
		    totalTrend=totalTrend+(maInputs[i]-maInputs[i-1]);
		}
		returnValue = maInputs[stop-1]+totalTrend;
	    }
	while(returnValue < 0) {
	    returnValue = (max+1) - returnValue;
	}
	while(returnValue > max){
	    returnValue = returnValue-(max+1);
	}
	if((returnValue < 0) || (returnValue > max)){
	    // printf("something wrong.  Return value is %f", returnValue);
	}

	return returnValue;
    }     

    public double getAverage (){
	if (numInputs ==0) return 0;
	else return (double)uncorrectedSum/numInputs;
    }
 

    //This function differs from getAverage in that it allows you to get the
    //average of the last x numbers instead of the entire history (up to declared
    //size of maInputs).

    public double getPartAverage (int x){
	double returnValue = 0.0;
	int myIndex, i;
	int start, stop;
	if(numInputs < width) {
	    stop = numInputs - 1;
	}else{ 
	    stop = width - 1; 
	}
  
	myIndex = (width + numInputs % width);
	if (x > width) {
	    // printf("number exceeds total in array, returning MovingAverage\n");
	    returnValue = getAverage();
	}else if(numInputs <= x) {
	    returnValue = getAverage();
	}else if((numInputs > x) && (numInputs <= width)) {
	    start=numInputs-x;
	    stop=numInputs;
    
	    for(i=(start); i < stop; i++) {
		returnValue += maInputs[i];
	    }
	    returnValue = returnValue / x;
	} else {
	    myIndex = ((width + numInputs) % width) -1;
	    for(i=0; i<x; i++) {
		if(myIndex < 0) {
		    myIndex = width-1;
		}
		returnValue += maInputs[myIndex];
		myIndex--;
	    }
	    returnValue = returnValue / (double) x;
	}
	return returnValue;
    }

    public double getLastNum (){
  
	return lastInput;
    } 

    public double getInputLag(int x){
	if (x >= width) {
	    System.out.println("input lag must be less than  width");
	    
	    System.exit(1);
	};
	
	arrayPosition = (width + numInputs -x -1) % width;
	return maInputs[arrayPosition];
    }


    public double addValue(double x){
	lastInput = x;
	arrayPosition = (width + numInputs) % width;
	if(numInputs < width)
	    {
		sumOfInputs+=x;
		maInputs[arrayPosition]=x;
	    }
	else
	    {
		sumOfInputs=sumOfInputs - maInputs[arrayPosition] + x ;
		maInputs[arrayPosition]=x;
	    }
	numInputs++;
    
	uncorrectedSum+=x;
	return this.getMA();
    }

}








