import swarm.Globals;
import swarm.objectbase.Swarm;
import swarm.activity.Activity;

import swarm.activity.ActionGroup;
import swarm.activity.ActionGroupImpl;

import swarm.activity.Schedule;
import swarm.activity.ScheduleImpl;
import swarm.simtoolsgui.GUISwarm;
import swarm.simtoolsgui.GUISwarmImpl;

import swarm.gui.Colormap;
import swarm.gui.ColormapImpl;
import swarm.defobj.Zone;
import swarm.Selector;


import swarm.analysis.EZGraph;
import swarm.analysis.EZGraphImpl;

import java.util.List;
import java.util.LinkedList;
import java.util.HashMap;

public class ObserverSwarm extends GUISwarmImpl {
    public final static int displayFrequency = 1;

    //id  stratHistogram;  //Histogram of how often strategies are used.
    //id  successHistogram; //Histogrm of how successful strategies are.

    public RuleBarGraph rulesBarGraph = null;
    public AttendanceScatterPlot attendanceScatter = null;

    public EZGraph aGraph;
	//aphCurAttendElement, aGraphCurAttendActiveGraph;
    //public EZGraph aGraphRAvgAttendElement, aGraphRAvgAttendActiveGraph;

    ActionGroup displayActions;	
    Schedule displaySchedule;
    Schedule stopSchedule;
    ModelSwarm modelSwarm;
    int drawStratHistogram = 0 ;
    int drawSuccessHistogram = 0;
   
    int experimentDuration = 50;
    int unattended; 

    MyParameter arguments;

    
    public ObserverSwarm (Zone aZone, MyParameter args){
	super (aZone); 
	unattended = args.unattended;
	arguments = args;
    }


public Object _aGraphDeath_ (Object caller) {
    aGraph.drop ();
    aGraph = null;
    return this;
  }
    


public Object buildObjects () {
    super.buildObjects ();
  

    Globals.env.createArchivedProbeDisplay (this, "ObserverSwarm");
    

    modelSwarm = new ModelSwarm (getZone(), arguments);


    getControlPanel ().setStateStopped ();

   
    Globals.env.createArchivedProbeDisplay (modelSwarm,
                                            "ModelSwarm");
    modelSwarm.buildObjects ();
    


    HashMap rules = modelSwarm.getRules ();

    rulesBarGraph = new RuleBarGraph("Rule Usage",rules,"RuleNo","Frequency", 22.0,100.0);

    Bar theBar = modelSwarm.getTheBar();

    attendanceScatter = new AttendanceScatterPlot("Attendance Scatterplot",theBar  ,"attendance(t-1)","attendance(t)",arguments.numAgents,arguments.numAgents);

    if (rules == null) System.out.println("no rules");

    aGraph = new EZGraphImpl (getZone(), 
			      "Attendance",
			      "time",
			      "Attendance",
			      "aGraph");
    
    try {
	aGraph.enableDestroyNotification$notificationMethod
	    (this, new Selector (getClass (), "_aGraphDeath_",false));
    } catch (Exception e) {
	System.err.println ("Exception _aGraphDeath: "+ e.getMessage ());
    }
    
  

    try {
	aGraph.createSequence$withFeedFrom$andSelector 
	    ("attendance", theBar,
	     new Selector (Class.forName ("Bar"),"getAttendance",false));
    } catch (Exception e){
	System.err.println ("Exception aGraphCreate 1: " + e.getMessage ());
    }

    try {
	aGraph.createSequence$withFeedFrom$andSelector 
	    ("average", theBar,
	     new Selector (Class.forName ("Bar"),"getRAvgAttendance",false));
    } catch (Exception e){
	System.err.println ("Exception aGraphCreate 2: " + e.getMessage ());
    }
    

    return this;

}


public Object stopRunning () {
    if ( Globals.env.getCurrentTime() == experimentDuration){ 
	if (unattended == 1){
	getControlPanel ().setStateQuit ();
	}

	else {
	    getControlPanel ().setStateStopped ();
	}
    }	
    return this;
}


    public void updateDisplay () {
	// raster.erase ();
	// display.display ();
	//raster.drawSelf ();
	System.out.println("observer update Display");
	aGraph.step();
	rulesBarGraph.update();
	attendanceScatter.update();
	Globals.env.probeDisplayManager.update ();
	getActionCache ().doTkEvents ();
	
	stopRunning();
    }


    //I dumped all the actions that used to be separately added to the
    //action group and put them intothe "updateDisplay" method.

    public Object buildActions () {
	super.buildActions ();
	modelSwarm.buildActions ();
    
	displayActions = new ActionGroupImpl (getZone());
    

    
	try {
	    displayActions.createActionTo$message 
		(this, new Selector (getClass (), "updateDisplay", false));
               
	} catch (Exception e) {
	    System.err.println ("Exception in setting up displayActions : " 
				+ e.getMessage ());
	}


	displaySchedule = new ScheduleImpl (getZone (), displayFrequency);
 
	displaySchedule.at$createAction (0, displayActions);

	return this;


    }



    public Activity activateIn (Swarm context) {
	super.activateIn (context);
	
	modelSwarm.activateIn (this);
	displaySchedule.activateIn (this);
	return getActivity ();
    }


    public void drop() {
	attendanceScatter.drop();
	rulesBarGraph.drop();
	super.drop();
    }
    


    public static void main (String[] args) {
	Globals.env.initSwarm ("SDG", "0.0", "bug-swarm@swarm.org", args);
	
	MyParameter arguments = new MyParameter ( args);
	ObserverSwarm observer = new ObserverSwarm (Globals.env.globalZone,arguments);
	

	Globals.env.createArchivedProbeDisplay (arguments, "MyParameter");
    
	if (observer.buildObjects () != null) {
	    observer.buildActions ();
	    observer.activateIn (null);
	    observer.go ();
	}
	else {
	    System.out.println("Your Observer is null");
	}
	System.exit(0);
    }
}












