  private double unhappiness = 0;
  private int x, y;
  private int idealTemp, outputHeat;
  private float randomMoveProb;

  private HeatSpace space;
  private Object2DTorus world;
  private Dimension worldSize;

  private int xSize;
  private int ySize;


  public Heatbug(HeatSpace space, Object2DTorus world, int x,
    int y, int idealTemp, int outputHeat, float randomMoveProb)
  {
    this.x = x;
    this.y = y;
    this.idealTemp = idealTemp;
    this.outputHeat = outputHeat;
    this.randomMoveProb = randomMoveProb;
    this.space = space;
    this.world = world;
    worldSize = world.getSize();
    xSize = worldSize.width;
    ySize = worldSize.height;
  }

  public void setXY(int x, int y) {
    this.x = x;
    this.y = y;
    world.putObjectAt(x, y, this);
  }

  public void heatbugStep() {
    long heatHere = (long)space.getValueAt(x, y);

    if (heatHere < idealTemp) {
      unhappiness = (double) (idealTemp - heatHere) / 0x7fff;
    } else {
      unhappiness = (double) (heatHere - idealTemp) / 0x7fff;
    }

    int type = (heatHere < idealTemp) ? 0 : 1;
    Point p = space.findExtreme(type, x, y);

    if (Uniform.staticNextFloatFromTo(0.0f, 1.0f) < randomMoveProb) {
      p.x = x + Uniform.staticNextIntFromTo(-1, 1);
      p.y = y + Uniform.staticNextIntFromTo(-1, 1);
    }

    if (unhappiness == 0) {
      space.addHeat(x, y, outputHeat);
    } else {
      int tries = 0;

      if (p.x != x || p.y != y) {
        while ((world.getObjectAt(p.x, p.y) != null) && tries < 10) {

          int location = Uniform.staticNextIntFromTo(1, 8);
          // get the neighbors
          int prevX = (x + xSize - 1) % xSize;
          int nextX = (x + 1) % xSize;
          int prevY = (y + ySize - 1) % ySize;
          int nextY = (y + 1) % ySize;

          switch (location) {
            case 1:
              p.x = prevX;
              p.y = prevY;
              break;
            case 2:
              p.x = x;
              p.y = prevY;
              break;
            case 3:
              p.x = nextX;
              p.y = prevY;
              break;
            case 4:
              p.x = nextX;
              p.y = y;
              break;
            case 5:
              p.x = prevX;
              p.y = y;
              break;
            case 6:
              p.x = prevX;
              p.y = nextY;
              break;
            case 7:
              p.x = x;
              p.y = nextY;
              break;
            case 8:
              p.x = nextX;
              p.y = nextY;
            default:
              break;
          }
          tries++;
        }
        if (tries == 10) {
          p.x = x;
          p.y = y;
        }

      }
      space.addHeat(x, y, outputHeat);
      world.putObjectAt(x, y, null);
      x = p.x;
      y = p.y;
      world.putObjectAt(x, y, this);
    }
  }

  public double getUnhappiness() {
    return unhappiness;
  }

  public void setUnhappiness(double value) {
    unhappiness = value;
  }

  public int getX() {
    return x;
  }

  public void setX(int x) {
    this.x = x;
  }

   public int getY() {
    return y;
  }

  public void setY(int y) {
    this.y = y;
  }

  public int getIdealTemp() {
    return idealTemp;
  }

  public void setIdealTemp(int idealTemp) {
    this.idealTemp = idealTemp;
  }

  public int getOutputHeat() {
    return outputHeat;
  }

  public void setOutputHeat(int outputHeat) {
    this.outputHeat = outputHeat;
  }

  public float getRandomMoveProb() {
    return randomMoveProb;
  }

  public void setRandomMoveProb(float f) {
    randomMoveProb = f;
  }
