/*$$
 * packages uchicago.src.*
 * Copyright (c) 1999, Trustees of the University of Chicago
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with 
 * or without modification, are permitted provided that the following 
 * conditions are met:
 *
 *	 Redistributions of source code must retain the above copyright notice,
 *	 this list of conditions and the following disclaimer.
 *
 *	 Redistributions in binary form must reproduce the above copyright notice,
 *	 this list of conditions and the following disclaimer in the documentation
 *	 and/or other materials provided with the distribution.
 *
 *	 Neither the name of the University of Chicago nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE TRUSTEES OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Nick Collier
 * nick@src.uchicago.edu
 *
 * packages cern.jet.random.*
 * Copyright (c) 1999 CERN - European Laboratory for Particle
 * Physics. Permission to use, copy, modify, distribute and sell this
 * software and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice appear in
 * supporting documentation. CERN makes no representations about the 
 * suitability of this software for any purpose. It is provided "as is" 
 * without expressed or implied warranty. 
 *
 * Wolfgang Hoschek
 * wolfgang.hoschek@cern.ch
 *$$*/


package collection;

/**
 * ColSlice: a slice of matrix columns
 *
 * @version 1.0 2/25/99
 * @author Nick Collier
 */

public class ColSlice extends Slice implements BaseMatrix {

  public ColSlice(Matrix m, int beg_col, int last_col) {
    super(m, beg_col, last_col);
    num_rows = m.num_rows;
    num_cols = last_col - beg_col + 1;
  }

  public MatrixIterator start() {
    return new MatrixIterator(this, 0);
  }

  public MatrixIterator end() {
    return new MatrixIterator(this, num_rows * num_cols);
  }

  public Object get(int row, int col) {
    checkIndex(row, col, num_rows, num_cols);
    return my_matrix.at(row, col + slice_begin);
  }

  public void put(int row, int col, Object obj) {
    checkIndex(row, col, num_rows, num_cols);
    my_matrix.put(row, col + slice_begin, obj);
  }

  public void putAtAll(Object obj) {
    for (int i = 0; i < num_rows; i++) {
      for (int j = 0; j < num_cols; j++) {
        my_matrix.put(i, j + slice_begin, obj);
      }
    }
  }

  // BaseMatrix interface
  public Object get(int index) {
    checkIndex(index, num_rows, num_cols);
    int row;
    int col;
    if (index < num_cols) {
      row = 0;
      col = index + slice_begin;
    } else {
      col = index % num_cols;
      row = (index - col) / num_cols;
      col += slice_begin;
    }
    return my_matrix.get(row, col);
  }

  public void put(int index, Object obj) {
    checkIndex(index, num_rows, num_cols);
    int row;
    int col;
    if (index < num_cols) {
      row = 0;
      col = index + slice_begin;
    } else {
      col = index % num_cols;
      row = (index - col) / num_cols;
      col += slice_begin;
    }
    my_matrix.put(row, col, obj);
  }

  public Object remove(int index) {
    return my_matrix.remove(index);
  }

  public Object remove(int row, int col) {
    return my_matrix.remove(row, col);
  }

  public int size() {
    return num_cols * num_rows;
  }
}
