/*$$
 * packages uchicago.src.*
 * Copyright (c) 1999, Trustees of the University of Chicago
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with 
 * or without modification, are permitted provided that the following 
 * conditions are met:
 *
 *	 Redistributions of source code must retain the above copyright notice,
 *	 this list of conditions and the following disclaimer.
 *
 *	 Redistributions in binary form must reproduce the above copyright notice,
 *	 this list of conditions and the following disclaimer in the documentation
 *	 and/or other materials provided with the distribution.
 *
 *	 Neither the name of the University of Chicago nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE TRUSTEES OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Nick Collier
 * nick@src.uchicago.edu
 *
 * packages cern.jet.random.*
 * Copyright (c) 1999 CERN - European Laboratory for Particle
 * Physics. Permission to use, copy, modify, distribute and sell this
 * software and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice appear in
 * supporting documentation. CERN makes no representations about the 
 * suitability of this software for any purpose. It is provided "as is" 
 * without expressed or implied warranty. 
 *
 * Wolfgang Hoschek
 * wolfgang.hoschek@cern.ch
 *$$*/


package collection;

/**
 * Slice: Abstract slice of a matrix.
 *
 * @version 1.0 2/25/99
 * @author Nick Collier
 */

public abstract class Slice {

  Matrix my_matrix = null;
  int slice_begin;
  int slice_end;
  int num_rows;
  int num_cols;

  Slice(Matrix m, int first, int last) {
    my_matrix = m;
    slice_begin = first;
    slice_end = last;
  }

  public int getNumRows() {
    return num_rows;
  }

  public int getNumCols() {
    return num_cols;
  }

  public abstract MatrixIterator start();
  public abstract MatrixIterator end();
  public abstract Object get(int row, int col);
  public abstract void put(int row, int col, Object obj);
  public abstract void putAtAll(Object obj);

  final protected static void checkIndex(int row, int col, int nrows, int ncols) {
    if (row >= nrows || row < 0|| col >= ncols || col < 0) {
      throw new IndexOutOfBoundsException ("Attempt to access row " + row +
        ", col " + col + ". Valid range is (0..." + (nrows - 1) + ", 0..." +
        ncols + ").");
    }
  }

  final protected static void checkIndex(int index, int nrows, int ncols) {
    int length = nrows * ncols;
    if (index < 0 || index >= length) {
      int row;
      int col;
      if (index < ncols) {
        row = 0;
        col = index;
      } else {
        col = index % ncols;
        row = (index - col) / ncols;
      }
      throw new IndexOutOfBoundsException ("Attempt to access row " + row +
        ", col " + col + ". Valid range is (0..." + (nrows - 1) + ", 0..." +
        ncols + ").");
    }
  }
}
