/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.PrintJob;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import ptolemy.plot.Message;
import ptolemy.plot.Plot;

public class PlotFrame
extends Frame {
    public Plot plot = new Plot();
    protected MenuBar _menubar = new MenuBar();
    protected Menu _fileMenu = new Menu("File");
    protected Menu _specialMenu = new Menu("Special");
    protected String _directory;
    protected String _filename;

    public PlotFrame() {
        this("Ptolemy Plot Frame");
    }

    public PlotFrame(String title) {
        super(title);
        MenuItem[] fileMenuItems = new MenuItem[]{new MenuItem("Open", new MenuShortcut(79)), new MenuItem("Save", new MenuShortcut(83)), new MenuItem("SaveAs", new MenuShortcut(65)), new MenuItem("Print", new MenuShortcut(80)), new MenuItem("Close", new MenuShortcut(87))};
        FileMenuListener fml = new FileMenuListener();
        int i = 0;
        while (i < fileMenuItems.length) {
            fileMenuItems[i].setActionCommand(fileMenuItems[i].getLabel());
            fileMenuItems[i].addActionListener(fml);
            this._fileMenu.add(fileMenuItems[i]);
            ++i;
        }
        this._menubar.add(this._fileMenu);
        MenuItem[] specialMenuItems = new MenuItem[]{new MenuItem("About", null), new MenuItem("Help", new MenuShortcut(72)), new MenuItem("Clear", new MenuShortcut(67)), new MenuItem("Fill", new MenuShortcut(70)), new MenuItem("Sample plot", null)};
        SpecialMenuListener sml = new SpecialMenuListener();
        int i2 = 0;
        while (i2 < specialMenuItems.length) {
            specialMenuItems[i2].setActionCommand(specialMenuItems[i2].getLabel());
            specialMenuItems[i2].addActionListener(sml);
            this._specialMenu.add(specialMenuItems[i2]);
            ++i2;
        }
        this._menubar.add(this._specialMenu);
        this.setMenuBar(this._menubar);
        this.add("Center", this.plot);
        ((Component)this).setSize(500, 300);
        ((Component)this).setVisible(true);
    }

    public void samplePlot() {
        this.plot.clear(true);
        this._filename = null;
        this._directory = null;
        this.plot.setTitle("Sample plot");
        this.plot.setYRange(-4.0, 4.0);
        this.plot.setXRange(0.0, 100.0);
        this.plot.setXLabel("time");
        this.plot.setYLabel("value");
        this.plot.addYTick("-PI", -Math.PI);
        this.plot.addYTick("-PI/2", -1.5707963267948966);
        this.plot.addYTick("0", 0.0);
        this.plot.addYTick("PI/2", 1.5707963267948966);
        this.plot.addYTick("PI", Math.PI);
        this.plot.setNumSets(10);
        this.plot.setMarksStyle("none");
        this.plot.setImpulses(true);
        boolean first = true;
        int i = 0;
        while (i <= 100) {
            this.plot.addPoint(0, i, 5.0 * Math.cos(Math.PI * (double)i / 20.0), !first);
            this.plot.addPoint(1, i, 4.5 * Math.cos(Math.PI * (double)i / 25.0), !first);
            this.plot.addPoint(2, i, 4.0 * Math.cos(Math.PI * (double)i / 30.0), !first);
            this.plot.addPoint(3, i, 3.5 * Math.cos(Math.PI * (double)i / 35.0), !first);
            this.plot.addPoint(4, i, 3.0 * Math.cos(Math.PI * (double)i / 40.0), !first);
            this.plot.addPoint(5, i, 2.5 * Math.cos(Math.PI * (double)i / 45.0), !first);
            this.plot.addPoint(6, i, 2.0 * Math.cos(Math.PI * (double)i / 50.0), !first);
            this.plot.addPoint(7, i, 1.5 * Math.cos(Math.PI * (double)i / 55.0), !first);
            this.plot.addPoint(8, i, Math.cos(Math.PI * (double)i / 60.0), !first);
            this.plot.addPoint(9, i, 0.5 * Math.cos(Math.PI * (double)i / 65.0), !first);
            first = false;
            ++i;
        }
        this.plot.repaint();
    }

    protected void _about() {
        Message message = new Message("Ptolemy plot frame\nBy: Edward A. Lee, eal@eecs.berkeley.edu\nand Christopher Hylands, cxh@eecs.berkeley.edu\nVersion 2.0, Build: $Id: PlotFrame.java,v 1.6 1998/11/21 02:09:06 lmuliadi Exp $\n\nFor more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot\n");
        message.setTitle("About Ptolemy Plot");
    }

    protected void _close() {
        this.dispose();
    }

    protected void _help() {
        Message message = new Message("PlotFrame is a versatile two-dimensional data plotter that runs as part of an application, but in its own window. It can read files compatible with the Ptolemy plot file format (currently only ASCII), or the application can interact directly with the contained Plot object, which is visible as a public member. For a description of the file format, see the Plot and PlotBox classes.");
        message.setTitle("Plot frame");
    }

    protected void _open() {
        FileDialog filedialog = new FileDialog((Frame)this, "Select a plot file");
        filedialog.setFilenameFilter(new PlotFilenameFilter());
        if (this._directory != null) {
            filedialog.setDirectory(this._directory);
        }
        ((Component)filedialog).setVisible(true);
        String filename = filedialog.getFile();
        if (filename == null) {
            return;
        }
        this._directory = filedialog.getDirectory();
        File file = new File(this._directory, filename);
        this._filename = null;
        try {
            this.plot.clear(true);
            this.plot.read(new FileInputStream(file));
        }
        catch (FileNotFoundException ex) {
            Message msg = new Message("File not found: " + ex);
        }
        catch (IOException ex) {
            Message message = new Message("Error reading input: " + ex);
        }
        this._filename = filename;
    }

    protected void _print() {
        PrintJob printjob = this.getToolkit().getPrintJob(this, this.getTitle(), null);
        if (printjob != null) {
            try {
                Graphics printgraphics = printjob.getGraphics();
                if (printgraphics != null) {
                    try {
                        this.plot.printAll(printgraphics);
                    }
                    finally {
                        Object var6_3 = null;
                        printgraphics.dispose();
                    }
                }
                Object var3_6 = null;
                printjob.end();
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                printjob.end();
                throw throwable;
            }
        }
    }

    protected void _save() {
        if (this._filename != null) {
            File file = new File(this._directory, this._filename);
            try {
                FileOutputStream fout = new FileOutputStream(file);
                this.plot.write(fout);
            }
            catch (IOException ex) {
                Message msg = new Message("Error writing file: " + ex);
            }
        } else {
            this._saveAs();
        }
    }

    protected void _saveAs() {
        FileDialog filedialog = new FileDialog((Frame)this, "Save plot as...");
        filedialog.setFilenameFilter(new PlotFilenameFilter());
        if (this._directory != null) {
            filedialog.setDirectory(this._directory);
        }
        filedialog.setFile("plot.plt");
        ((Component)filedialog).setVisible(true);
        this._filename = filedialog.getFile();
        if (this._filename == null) {
            return;
        }
        this._directory = filedialog.getDirectory();
        this._save();
    }

    class FileMenuListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            MenuItem target = (MenuItem)e.getSource();
            String actionCommand = target.getActionCommand();
            if (actionCommand.equals("Open")) {
                PlotFrame.this._open();
            } else if (actionCommand.equals("Save")) {
                PlotFrame.this._save();
            } else if (actionCommand.equals("SaveAs")) {
                PlotFrame.this._saveAs();
            } else if (actionCommand.equals("Print")) {
                PlotFrame.this._print();
            } else if (actionCommand.equals("Close")) {
                PlotFrame.this._close();
            }
        }

        FileMenuListener() {
            PlotFrame.this = PlotFrame.this;
        }
    }

    class SpecialMenuListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            MenuItem target = (MenuItem)e.getSource();
            String actionCommand = target.getActionCommand();
            if (actionCommand.equals("About")) {
                PlotFrame.this._about();
            } else if (actionCommand.equals("Help")) {
                PlotFrame.this._help();
            } else if (actionCommand.equals("Fill")) {
                PlotFrame.this.plot.fillPlot();
            } else if (actionCommand.equals("Clear")) {
                PlotFrame.this.plot.clear(false);
                PlotFrame.this.plot.repaint();
            } else if (actionCommand.equals("Sample plot")) {
                PlotFrame.this.plot.clear(true);
                PlotFrame.this.samplePlot();
            }
        }

        SpecialMenuListener() {
            PlotFrame.this = PlotFrame.this;
        }
    }

    class PlotFilenameFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return (name = name.toLowerCase()).endsWith(".plt");
        }

        PlotFilenameFilter() {
            PlotFrame.this = PlotFrame.this;
        }
    }
}

