import java.util.Iterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ArrayList;

import java.awt.Color;
import javax.swing.JFrame;

import swarm.Globals;

import ptolemy.plot.Plot;
public class StrategyGrapher extends Plot {
    private boolean connected = false;
    private HashMap strategies = null;
    private HashMap dataSets = null;
    private JFrame myFrame = null;
    public StrategyGrapher(String title, HashMap collection, 
                           String xLabel,
                           String yLabel, int xRange, int yRange) {
        myFrame = new JFrame();
        setTitle(title);
        myFrame.setTitle(title);
        setCollection(collection);
        setXRange(0,xRange);
        setYRange(0,yRange);
        _xTop = (double)xRange;
        _yTop = (double)yRange;
        setMarksStyle("points");
        setXLabel(xLabel);
        setYLabel(yLabel);
        setButtons(true);
        setPointsPersistence(1000);
        myFrame.setSize(400,300);
        myFrame.getContentPane().add(this);
        myFrame.show();
    }
    public synchronized void setCollection(HashMap collection) {
        strategies = collection;
        int dataSetCount=0;
        Iterator ndx = strategies.keySet().iterator();
        // strategies are statically defined => we can do this once and for all
        dataSets = new HashMap();
        while (ndx.hasNext()) {
            Strategy s = (Strategy)ndx.next();
            dataSets.put(s,new Integer(dataSetCount));
            addLegend(dataSetCount,s.name);
            dataSetCount++;
        }
    }
    public synchronized Object addPoints() {
        // iterate collection and plot number of players for each strategy
        Iterator ndx = strategies.keySet().iterator();
        boolean needRepaint = false;
        while (ndx.hasNext()) {
            Strategy nextStrategy = (Strategy)ndx.next();
            double newPointY = (double)
                ((HashSet)strategies.get(nextStrategy)).size();
            if (newPointY > _yTop+30.0) {
                setYRange(0,newPointY+50);
                needRepaint = true;
            }
            double newPointX = (double) Globals.env.getCurrentTime();
            if (newPointX > _xTop+30.0) {
                setXRange(0,newPointX+50);
                needRepaint = true;
            }
            addPoint(((Integer)dataSets.get(nextStrategy)).intValue(),
                     newPointX, newPointY, connected);
        }
        if (needRepaint) repaint();
        connected = true;
        return this;
    }

    public void drop() {
        strategies.clear();
        dataSets.clear();
        myFrame.dispose();
    }
}
