// Agent.h for the 3dDemo app.
// Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// Look for the "//   3d-specific:" string to find comments relevant
// only to this demo.

#import <swarmobject.h>		
#import <space.h>		
#import <tkobjc/Raster.h>	

@interface Agent: SwarmObject {

  //  3d-specific:  An extra coordinate.
  int x, y, z;
  int oldX, oldY, oldZ;

  //  3d-specific:  Instead of creating an instance of 
  //  3d-specific:  Discrete2d or Grid2d, use Discrete3d.
  Discrete3d * world;

  //  3d-specific:  And an extra size variable.
  int worldXSize, worldYSize, worldZSize;
  Color agentColor;
}

-setSpace: (Discrete3d *) w;
-createEnd;

//  3d-specific:  Gotta set 3 variables instead of two.
-setX: (int) x Y: (int) y Z: (int) z;
-setAgentColor: (Color) c;

-step;

-drawSelfOn: (Raster *) r;

@end
