// Agent.m for the 3dDemo app.
// Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// Look for the "//   3d-specific:" string to find comments relevant
// only to this demo.

#import "Agent.h"
#import <simtools.h>

@implementation Agent

-setSpace: (Discrete3d *) s {
  world = s;
  worldXSize = [world getSizeX];
  worldYSize = [world getSizeY];

  //  3d-specific:  There's another coordinate to this space, 
  //  3d-specific:  which adds another variable.
  worldZSize = [world getSizeZ];

  return self;
}

-createEnd {
  [super createEnd];
  return self;
}

//  3d-specific:  Same as in the 2d world except for the 
//  3d-specific:  extra coordinate.
-setX: (int) inX Y: (int) inY Z: (int) inZ {
  x = inX;
  y = inY;
  z = inZ;
  [world putObject: self atX: x Y: y Z: z];
  return self;
}

-step {
  int newX, newY, newZ;
  int tries;
  
  //  3d-specific:  This defines the 3d equivalent of a 
  //  3d-specific:  Moore neighborhood in 2d space.  So, 
  //  3d-specific:  any given spot is the center of a ball (block? :-)
  //  3d-specific:  of 9*3 cells in size.
  newX = (x + [uniformRandom rMin: -1 Max: 2]); // pick a random spot
  newY = (y + [uniformRandom rMin: -1 Max: 2]);
  newZ = (z + [uniformRandom rMin: -1 Max: 2]);

  newX = (newX + worldXSize) % worldXSize;	  // normalize coords
  newY = (newY + worldYSize) % worldYSize;
  //  3d-specific:  Normalization of the space occurs exactly the same
  //  3d-specific:  in the third dimension as it does in the 1st two.
  newZ = (newZ + worldZSize) % worldZSize;

  tries = 0;
  while ([world getObjectAtX: newX Y: newY Z: newZ] != nil && tries < 10) {
    newX = (x + [uniformRandom rMin: -1 Max: 2] + worldXSize) % worldXSize;
    newY = (y + [uniformRandom rMin: -1 Max: 2] + worldYSize) % worldYSize;
    newZ = (y + [uniformRandom rMin: -1 Max: 2] + worldYSize) % worldYSize;
    tries++;
  }
  if (tries == 10) {
    newX = x;
    newY = y;
    newZ = z;
  }

  [world putObject: nil atX: x Y: y Z: z];
  //  3d-specific:  I'm caching the old value so that the agent 
  //  3d-specific:  is able to clean up after itself instead of 
  //  3d-specific:  refreshing the raster each time.  This is not
  //  3d-specific:  really 3d-specific; but, provides an example
  //  3d-specific:  of another way to get rid of the trail left 
  //  3d-specific:  behind by an agent.  (The equivalent of those
  //  3d-specific:  "trail-duster" coats you always see in the
  //  3d-specific:  Westerns.)
  oldX = x; oldY = y; oldZ = z;
  x = newX;
  y = newY;
  z = newZ;
  [world putObject: self atX: newX Y: newY Z: newZ];

  return self;
}

-setAgentColor: (Color) c {
  agentColor = c;
  return self;
}

-drawSelfOn: (Raster *) r {
  //  3d-specific:  And here's where the "trailduster" shows up.
  [r drawPointX: oldX Y: oldY Color: 0];
  [r drawPointX: x Y: y Color: agentColor];
  return self;
}

@end
