// AgentModelSwarm.h

// Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <swarmobject.h>
#import <space.h>
#import <activity.h>
#import <collections.h>
#import "Agent.h"

@interface AgentModelSwarm : Swarm {
  int numAgents;
  int worldXSize, worldYSize, worldZSize;

  id modelActions;
  id modelSchedule;

  id agentList;
  Discrete3d * world;

}

+createBegin: (id) aZone;  // extra methods you provide for Swarms
-createEnd;
-buildObjects;
-buildActions;
-activateIn: (id) swarmContext;

-getAgentList;
-getSpace;

@end
