// AgentObserverSwarm.m
// Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// Look for the "//   3d-specific:" string to find comments relevant
// only to this demo.

#import "AgentObserverSwarm.h"
#import "AgentModelSwarm.h"
#import <collections.h>
#import <swarmobject.h>

@implementation AgentObserverSwarm

+createBegin: (id) aZone {
  AgentObserverSwarm * obj;
  ProbeMap * probeMap;
  
  obj = [super createBegin: aZone];

  obj->displayFrequency = 1;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "displayFrequency"
				    inClass: [self class]]];

  [probeLibrary setProbeMap: probeMap For: [self class]];

  return obj;
}

-createEnd {
  return [super createEnd];
}

-buildObjects {
  id modelZone;	// zone for model.
  int i;
  id agentToProbe;

  [super buildObjects];
  
  modelZone = [Zone create: [self getZone]];
  agentModelSwarm = [AgentModelSwarm create: modelZone];
  
  [probeDisplayManager createProbeDisplayFor: agentModelSwarm];
  [probeDisplayManager createProbeDisplayFor: self];

  [controlPanel waitForControlEvent];
  if ([controlPanel getState] == ControlStateQuit)
    return self;

  [agentModelSwarm buildObjects];

  colormap = [XColormap create: [self getZone]];
  for (i = 0; i < 63; i++)
    [colormap setColor: i ToRed: (double)i / 62.0 Green: 0 Blue: 0];
  [colormap setColor: 64 ToName: "green"];
  [colormap setColor: 65 ToName: "white"];

  [[agentModelSwarm getAgentList] forEach: M(setAgentColor:) : (void *) 64];
  
  // Next, create a 2d window for display, set its size, zoom factor, title.
  //   3d-specific:  If one wanted to view more than one plane or 
  //   3d-specific:  projection of the 3d space, one would need to 
  //   3d-specific:  either create more rasters (one for each cut to
  //   3d-specific:  be viewed *or* provide some way to switch between
  //   3d-specific:  cuts.
  worldRaster = [ZoomRaster create: [self getZone]];
  [worldRaster setColormap: colormap];
  [worldRaster setZoomFactor:8];
  [worldRaster setWidth: [[agentModelSwarm getSpace] getSizeX]
	       Height: [[agentModelSwarm getSpace] getSizeY]];
  [worldRaster setWindowTitle: "World"];
  [worldRaster pack]; // draw the window.

  // And also create an Object2dDisplay: this object draws agents on
  // the worldRaster widget for us, and also receives probes.
  //   3d-specific:  In this demo, the Object2dDisplay sends messages
  //   3d-specific:  to every agent in the agentList to display on 
  //   3d-specific:  the single worldRaster.  This results in all 
  //   3d-specific:  agents' being displayed on the single raster,
  //   3d-specific:  effectively creating a 2d projection of the 
  //   3d-specific:  3d space.  But, it's not a perfect projection
  //   3d-specific:  because if an agent occludes another agent, then
  //   3d-specific:  moves, that spot on the 2d raster will be blackened,
  //   3d-specific:  which means that the occluded agent will be there
  //   3d-specific:  but won't be shown on the raster.
  agentDisplay = [Object2dDisplay createBegin: [self getZone]];
  [agentDisplay setDisplayWidget: worldRaster];
  [agentDisplay setDiscrete2dToDisplay: [agentModelSwarm getSpace]];
  [agentDisplay setObjectCollection: [agentModelSwarm getAgentList]];
  [agentDisplay setDisplayMessage: M(drawSelfOn:)];   // draw method
  agentDisplay = [agentDisplay createEnd];

  // Also, tell the world raster to send mouse clicks to the agentDisplay
  // this allows the user to right-click on the display to probe the agts.

  // 3d-specific: The normal hook between a button click and a probe
  // 3d-specific: won't work here because the Discrete3d object will not
  // 3d-specific: respond to getObjectAtX:Y: message, wich is used by
  // 3d-specific: the Object2dDisplay.  See the READ.ME.
  //[worldRaster setButton: ButtonRight Client: agentDisplay Message: M(makeProbeAtX:Y:)];


  // Finally, we create a Probe display to probe a particular agent.
  // Probes can also be created on the fly, we just do this here for demo.
  //   3d-specific:  This was left in to show that the agents can still
  //   3d-specific:  be probed, despite Discrete3d being unable to handle
  //   3d-specific:  the hook between button clicks and makeProbeAtX:Y:.
  //   3d-specific:  It also shows the 3 coordinates of the sample agent
  //   3d-specific:  as it moves around in space.
  agentToProbe = [[agentModelSwarm getAgentList] first];
  [agentToProbe setAgentColor: 65]; // to white
  [probeDisplayManager createProbeDisplayFor: agentToProbe];

  return self;
}  

-buildActions {
  [super buildActions];
  
  [agentModelSwarm buildActions];
  
  displayActions = [ActionGroup create: [self getZone]];

  [displayActions createActionTo: agentDisplay      message: M(display)];

  //   3d-specific:  The agent's "drawSelf" method also "undraws" the 
  //   3d-specific:  last spot it occupied.  This makes the object a 
  //   3d-specific:  little cluttered; but, illustrates another way 
  //   3d-specific:  this can be done.
  [displayActions createActionTo: worldRaster         message: M(drawSelf)];

  [displayActions createActionTo: probeDisplayManager message: M(update)];
  [displayActions createActionTo: controlPanel        message: M(doTkEvents)];

  displaySchedule = [Schedule createBegin: [self getZone]];
  [displaySchedule setRepeatInterval: displayFrequency]; // note frequency!
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];
  
  return self;
}  

-activateIn: (id) swarmContext {
  [super activateIn: swarmContext];

  [displaySchedule activateIn: self];

  [agentModelSwarm activateIn: self];

  return [self getSwarmActivity];
}

-(int)getDisplayFrequency
{
  return displayFrequency;
}

@end
