// Main.m

// Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import "AgentObserverSwarm.h"

// The main() function is the top-level place where everything starts.
// For a typical Swarm simulation, in main() you create a toplevel
// Swarm, let it build and activate, and set it to running.

int
main(int argc, char **argv) {
  AgentObserverSwarm *observerSwarm;

  // Swarm initialization: all Swarm apps must call this first.
  initSwarm(argc, argv);
  
  observerSwarm = [AgentObserverSwarm create: globalZone];
  [observerSwarm buildObjects];
  [observerSwarm buildActions];
  [observerSwarm activateIn: nil];
  [observerSwarm go];

  // The toplevel swarm has finished processing, so it's time to quit.
  return 0;
}

