#!/usr/bin/perl
# A script that takes all files with .ppm extension
# in the current directory and converts them to gifs
# Requires the ppmtogif utility which is in netpbm
# Benedikt Stefansson <benedikt@ucla.edu> 7/1997

opendir(THISDIR,".");
@ppmfiles=grep(/\.ppm/,readdir(THISDIR));

while(@ppmfiles) {
    # Start by extracting the filename
    $ppmfile=shift(@ppmfiles);
    # Strip out the first part of the name
    $ppmfile =~ /([0-9]+).ppm/;
    # Use that to make giffilename
    $giffile=$1 . ".gif";

    # Then write out the giffile and erase the ppmfile
    system("ppmtogif $ppmfile > $giffile");
    system("rm $ppmfile");
}


exit(0);
