// -*- mode: objc
// Template application. Copyright  1996-2000 Swarm Development Group.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import "PopObsSwarm.h"
#import <analysis.h> // EZGraph

// implementation of sample graphical interface for models.
@implementation PopulationObserverSwarm

+ createBegin: aZone
{
  PopulationObserverSwarm * obj;
  id <ProbeMap> probeMap;
  
  obj = [super createBegin: aZone];

  // MODIFY: initialize other display options here.
  obj->displayFrequency = 1;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  // MODIFY: set any display parameters here.
  [probeMap addProbe: [probeLibrary getProbeForVariable: "displayFrequency"
				    inClass: [self class]]];

  [probeLibrary setProbeMap: probeMap For: [self class]];

  return obj;
}

// MODIFY: possible creation finalization here
- createEnd
{
  return [super createEnd];
}

- setChromLength: (unsigned)_len
{
  chromLen = _len;
  return self;
}

- setEvaluationFunc: (float(*)(id))_evalFunc
{
  evalFunc = _evalFunc;
  return self;
}

- buildObjects
{
  id modelZone;
  
  [super buildObjects];
  
  modelZone = [Zone create: [self getZone]];

  // Start creating population, needed to set the evaluation function
  populationSwarm = [PopulationSwarm create: modelZone ];
  [populationSwarm setEvaluationFunc: evalFunc];
  [populationSwarm setChromLength: chromLen];

  CREATE_ARCHIVED_PROBE_DISPLAY (populationSwarm);
  CREATE_ARCHIVED_PROBE_DISPLAY (self);

  [actionCache waitForControlEvent];
  if ([controlPanel getState] == ControlStateQuit)
    return self;

  [populationSwarm buildObjects];

  // Create Graph for displaying fitness and data element
  fitnessGraph =  [EZGraph createBegin: modelZone];
  SET_WINDOW_GEOMETRY_RECORD_NAME (fitnessGraph);
  [fitnessGraph setTitle: "Fitness Evolution" ];
  [fitnessGraph setAxisLabelsX: "Time" Y: "Fitness"];
  fitnessGraph= [fitnessGraph createEnd];

  [fitnessGraph createAverageSequence: "Average fitness"
		withFeedFrom: [populationSwarm getList]
		andSelector: M(getFitness) ];

  [fitnessGraph createMinSequence: "Min fitness"
		withFeedFrom: [populationSwarm getList]
		andSelector: M(getFitness) ];

  [fitnessGraph createMaxSequence: "Max fitness"
		withFeedFrom: [populationSwarm getList]
		andSelector: M(getFitness) ];

  return self;
}  

- buildActions
{
  [super buildActions];
  
  [populationSwarm buildActions];

  // MODIFY: schedule display objects here.
  displayActions = [ActionGroup create: [self getZone]];
  // Now schedule the update of the fitness graph
  [displayActions createActionTo: fitnessGraph  message: M(step)];
  // Schedule the update of the probe displays
  [displayActions createActionTo: probeDisplayManager message: M(update)];
  // Finally, schedule an update for the whole user interface code.
  // This is crucial: without this, no graphics update and the control
  // panel will be dead. It's best to put it at the end of the display schedule
  [displayActions createActionTo: actionCache message: M(doTkEvents)];
  [displayActions createActionTo: self message: M(checkToStop) ];

  displaySchedule = [Schedule createBegin: [self getZone]];
  [displaySchedule setRepeatInterval: displayFrequency];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];

  return self;
}  

- activateIn: swarmContext
{
  [super activateIn: swarmContext];
  
  [populationSwarm activateIn: self];
  [displaySchedule activateIn: self];
  
  return [self getSwarmActivity];
}

- checkToStop
{
  if ( [populationSwarm getGenerations] 
       <= [populationSwarm getGenerationCount])
    [controlPanel setStateStopped];
  return self;
}

@end

