#import <gui.h>
#import <simtools.h>
#import "SimObject.h"
#import "PriorityQueue.h"

#import "globals.h"

@interface Boid: SimObject
{
  id <Vector> acceleration; // [m/(sec^2)] acceleration requested at last update.
  id <Vector> flockCenter;  // the center of the flock I see
  id <Vector> flockVelocity; //Average velocity of the local agents 

//Parameters

  double cruiseDistance;    // [m] Default value is twice the bodylength.

  // double bodyRadius;   //declared in super class
/*  double maxVelocity;       // [m/sec]  MOVED TO PARAMETER SPACE
  double maxAcceleration;   // [m/(sec^2)]
  double interactionDist;
  double fieldOfView;
  double centeringStrength;
  double velocityMatchStrength;
  double desiredCruisingSpeed;
*/  
// instance variables

  double myDestX; 
  double myDestY; 

  BOOL skipNavigation;

  Boid* closestBoid;
  //id closestPred;
  //id closestObstacle;

  id <Vector> yourCalcPosition;

  PriorityQueue *visibleBoids[NUMOBJECTTYPES]; // known objects sorted by distance
}

+ (Boid *)create: aZone;
- createEnd;

- init: (int) id : (int) type
      : (id <Vector>) p
      : (id <Vector>) v;



- step;

- (double) accumulate: (id <Vector>)valueToAdd;
- (double) getProbeLength;
// Returns how far in front of boid to probe for obstacles.
- updateVisibilityList;
  
- (id <Vector>)wander;
  // Returns a vector which indicates how the boid would like to accelerate
  // when not under any other influences. Related to desiredCruisingSpeed().

- (id <Vector>)collisionAvoidance;
  // Returns a vector which indicates how the boid would like to accelerate
  // in order to avoid collisions with non-boid obstacles.

- (id <Vector>)maintainingCruisingDistance;
  // Returns a vector which indicates how the boid would like to accelerate
  // in order to maintain a distance of cruiseDistance from the nearest
  // visible boid. 

- (id <Vector>)velocityMatching;
  // Returns a vector which indicates how the boid would like to accelerate
  // in order to fly at approximately the same speed and direction as the
  // nearby boids.

- (id <Vector>)flockCentering;
  // Returns a vector which indicates how the boid would like to accelerate
  // in order to be near the center of the flock.

- (id <Vector>)predatorAvoidance;
// PREY avoids PREDATORs

- (id <Vector>)navigator;
// This method prioritizes and resolves the acceleration vectors
// It returns the actual acceleration vector that the boid will apply
// to its flight in the current time step.
  



- sendToX: (double) aLocationX 
        Y: (double) aLocationY;
// This message is sent from the boids world (BoidSpace). 
// It interrupts the navigator and places birds at the new location 
//
//

@end

