#import "ModelSwarm.h"
#import "Boid.h"
#import "Vector.h"
#import <random.h>
#import <objectbase.h>


// Implementation of the model for ppl.

@implementation ModelSwarm

+ create: aZone {

  id <ProbeMap> probeMap;
  ModelSwarm *obj;

  obj = [super create: aZone];

  obj->numAgents = 100;
  obj->numberOfBoids = 0;
  obj->agentID   = 0;
  obj->worldXSize = -1;
  obj->worldYSize = -1;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "numberOfBoids"
                                    inClass: [self class]]];
  //[probeMap addProbe: [probeLibrary getProbeForVariable: "numAgents"
                                    //inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "worldXSize"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "worldYSize"
                                    inClass: [self class]]];

  //  probeMap = [CustomProbeMap create: aZone
  //			     forClass: [self class]
  //			     withIdentifiers: "numAgents",
  //			     "worldXSize",
  //			     "worldYSize", NULL];

  [probeLibrary setProbeMap: probeMap For: [self class]];
  
  return obj;

}



///////////////////////////////////////////////////////
//
// buildObjects
//
///////////////////////////////////////////////////////
- buildObjects {

  int i, type;
  double x, y;
  double vx, vy;
  Vector *position   = [Vector create: self];
  Vector *velocity   = [Vector create: self];
  Boid *agent;
 
  
  //  printf ("ModelSwarm\tbuildObjects\n");

  if(boidRaster == nil) {

      [InternalError raiseEvent: "ERROR: MODELSWARM >>>> buildObjects boidRaster is nil\n"];
 
  }

  if( (worldXSize < 0) || (worldYSize < 0) ) {

      [InternalError raiseEvent: "ERROR: MODELSWARM >>>> buildObjects world(XY)Size negative\n"];

  }


  [super buildObjects];





  // build the list to keep track of the agents
  objectList  = [List create: self];

  //
  // Build the discrete2d space
  //
  boidSpace = [BoidSpace createBegin: self];

  [boidSpace setSizeX: worldXSize Y: worldXSize];

  [boidSpace setRaster: boidRaster];
  [boidSpace setBoids: objectList];



  boidSpace = [boidSpace createEnd];
 
  
   paramSpace = [ParameterSpace create: self];
   [ObjectLoader load: paramSpace fromFileNamed: "Boid.Params"];





  // build the boids
  for (i = 0; i < numberOfBoids; i++) {
    
      x = [uniformDblRand getDoubleWithMin: 0.0 withMax: (double) worldXSize];
      y = [uniformDblRand getDoubleWithMin: 0.0 withMax: (double) worldYSize];

      vx = [uniformDblRand getDoubleWithMin: -5.0 withMax: 5.0];
      vy = [uniformDblRand getDoubleWithMin: -5.0 withMax: 5.0];

      //type = [uniformIntRand getIntegerWithMin: 0 withMax: NUMBOIDTYPES-1];
     // type = [uniformIntRand getIntegerWithMin: 0 withMax: 0];
        type = 0;

/*
      if (type == PREDATOR) {

          type = [uniformIntRand getIntegerWithMin: 0 withMax: NUMBOIDTYPES-1];

      }
*/
      if(0) {

           fprintf(stderr, "MODELSWARM >>>> buildObjects type = %d\n", (int) type);
           fflush(0);

      }


      agent = [Boid create: self];


      //[ObjectLoader load: agent fromFileNamed: "Boid.Params"];

      [agent init: ++agentID : type
                             : [position init: x : y]
                             : [velocity init: vx : vy]];

      [agent initModel: self];
      [agent initParamSpace: paramSpace];
      [agent createEnd];
      [objectList addLast: agent];



  }  // for numAgents


  // THIS IS BROKEN, DON'T TRY IT, EVEN IN THE OFFICE.
  // Now create some obstacles
  //
/*  if(0) {

      [velocity init]; // reset to {0.0, 0.0}
      agent = [SimObject create: self];
      [agent init: ++agentID : OBSTACLE
	     : [position init: worldXSize/4 : worldYSize/2.0] : velocity : 20.0];
      [agent initModel: self];
      [agent createEnd];
      [objectList addLast: agent];
  
      agent = [SimObject create: self];
      [agent init: ++agentID : OBSTACLE
	     : [position init: worldXSize/2 : worldYSize/4.0] : velocity : 20.0];
      [agent initModel: self];
      [agent createEnd];
      [objectList addLast: agent];
  
      agent = [SimObject create: self];
      [agent init: ++agentID : OBSTACLE
	     : [position init: worldXSize/2 : worldYSize/2.0] : velocity : 20.0];
      [agent initModel: self];
      [agent createEnd];
      [objectList addLast: agent];

  }
*/  
  [position   drop];
  [velocity   drop];

  // printf("ModelSwarm:\tbuildObjects:\tDone.\n");
  return self;

}



//////////////////////////////////////////////////////////
//
// buildActions
//
/////////////////////////////////////////////////////////
- buildActions {

  [super buildActions];

  //  printf("ModelSwarm:\tbuildActions:\tbegin.\n");

  modelSchedule = [Schedule createBegin: self];
  [modelSchedule setRepeatInterval: 1];
  modelSchedule = [modelSchedule createEnd];

  [modelSchedule at: 0 createActionForEach: objectList message: M(step)];
  //[modelSchedule at: 0 createActionTo: self message: M(dropDead)];

  return self;

}

- activateIn: swarmContext {

  // send a message to our super activating ourselves in their schedule
  [super activateIn: swarmContext];

  // then send a message to our schedule to start our actions
  [modelSchedule activateIn: self];

  // pass back the SwarmActitivity in the queue
  return [self getSwarmActivity];

}


//////////////////////////////////////////////////////////
//
////      SET
//////
////////
/////////////////////////////////////////////////////////
- setRaster: (id <Raster>) aRaster {

  boidRaster = aRaster;

  return self;

}
    

/*

///////////////////////////////////////////
//
// setCanvas
//
///////////////////////////////////////////
- setCanvas: (id <Canvas>) c
{
  canvas = c;
  return self;
}

*/


/////////////////////////////////////////////
//
// getParameterSpace
//
/////////////////////////////////////////////
- (ParameterSpace *) getParameterSpace
{
  return paramSpace;
}


/*

/////////////////////////////////////////
//
// display
//
////////////////////////////////////////
- display
{
  [objectList forEach: @selector(display)];
  return self;
}


*/

/////////////////////////////////////////////////
//
// getObjectList
//
////////////////////////////////////////////////
- (id <List>) getObjectList { 
 
        return objectList;

}



/////////////////////////////////////////////////////
//
// getWorldSize 
//
///////////////////////////////////////////////////
- (int) getWorldXSize { return worldXSize;}
- (int) getWorldYSize { return worldYSize;}



///////////////////////////////////////////////////
//
// getBoidSpace
//
//////////////////////////////////////////////////
- getBoidSpace {

   return boidSpace;

}


//////////////////////////////////////////////////
//
// getBoids
//
//////////////////////////////////////////////////
- getBoids {

   return objectList;

}


@end

