// PriorityQueue.h

#import <objectbase/SwarmObject.h>

@interface PriorityQueue: SwarmObject
{
  int size;
  id subject;
  double priority;
  PriorityQueue *parent;
  PriorityQueue *higher;
  PriorityQueue *lower;
}

+ (PriorityQueue *) create: aZone;
+ (PriorityQueue *) create: aZone withParent: (PriorityQueue *) aQueue;

- (void) drop;

- (int) getCount;
- addObject: anObject with: (double) aPriority;
- addQueue: (PriorityQueue *) aQueue;
- getFirst; // return object with highest priority
- getLast;  // return object with lowest priority
- removeFirst;
- removeLast;
- removeAll;


- (void) forEach: (SEL) op;
- (void) forEach: (SEL) op : arg;
@end;
