//EPDAgent.h EPD
//Copyright James Marshall 1998-2002. Freely distributable under the GNU General Public Licence

#import <objectbase/SwarmObject.h>
#import <collections.h>
#import "EPDDefines.h"
#import "EPDWorld.h"
#import "DoubleData.h"
#import <random.h>

@interface EPDAgent: SwarmObject
{
  BOOL alive;
  BOOL played;
  BOOL mated;
  id strategy;
//  id <ListIndex> history;
  id history;
  int x, y, currentAction;
  float fitness;
  int totalInteractions, totalFitness;
  int energy;
  id myWorld;
}

-setupWorld: world x: (int) xPos y: (int) yPos;

-createEnd;

-move;
-play;
-mate;
-(float)getFitness;
-(id)getHistory;
-(id)getStrategy;
-(void)setStrategyAtOffset: (int) offset value: (int) value;
-(BOOL)isAlive;
-(BOOL)hasPlayed;
-(BOOL)hasMated;
-(void)setMated;
-(int)getCurrentAction;
-(void)setCurrentAction: (int) action;
-(void)updateFitness: (int) payoff;
-(void)increaseEnergy: (int) payoff;
-(void)drop;

@end
