//EPDObserverSwarm.m EPD
//Copyright James Marshall 1998-2002. Freely distributable under the GNU General Public Licence

#import "EPDObserverSwarm.h"

@implementation EPDObserverSwarm

+createBegin: (id) aZone
{
  EPDObserverSwarm *obj;
  id <ProbeMap> probeMap;

  obj=[super createBegin: aZone];
  obj->displayFrequency=1;

  //create the probe map for the observer Swarm
  probeMap=[EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap=[probeMap createEnd];

  //add a probe for display frequency to the probe map, and set the probe map for the observer Swarm
  [probeMap addProbe: [probeLibrary getProbeForVariable: "displayFrequency" inClass: [self class]]];
  [probeLibrary setProbeMap: probeMap For: [self class]];

  return obj;
}

-createEnd
{
  return [super createEnd];
}

-buildObjects
{
  id modelZone;
  int l1,l2, zf;

  [super buildObjects];

  //create the model Swarm
  modelZone=[Zone create: [self getZone]];
  epdSwarm=[EPDSwarm create: modelZone];

  //create the probe displays for the model and observer Swarms
  [probeDisplayManager createProbeDisplayFor: epdSwarm];
  [probeDisplayManager createProbeDisplayFor: self];

  [controlPanel setStateStopped];

  //build the objects in the model Swarm
  [epdSwarm buildObjects];

  //create a colour map (grey scale) for displaying cell population densities
  populationColourMap=[Colormap create: modelZone];
  [populationColourMap setColor: 0 ToName: "blue"];
  for (l1=1; l1<=10; l1++)
  {
    [populationColourMap setColor: l1 ToGrey: (double)l1/10];
  }

  //create a colour map for displaying cell cooperation and relatedness levels
  worldColourMap=[Colormap create: modelZone];
  [worldColourMap setColor: 0 ToName: "black"];
  for (l1=0; l1<=10; l1++)
  {
    for (l2=0; l2<=10; l2++)
    {
      [worldColourMap setColor: (l1*11)+l2+1 ToRed: (double)l1/10 Green: (double)l2/10 Blue: (double)1];
    }
  }
  [worldColourMap setColor: 122 ToRed: 1 Green: 0 Blue: 0]; //red for individual agents

  //create a raster object for displaying cell population densities
  zf=500/[epdSwarm getWorldXSize];
  if (zf>50)
  {
    zf=50;
  }

  populationRaster=[ZoomRaster create: modelZone];
  [populationRaster setColormap: populationColourMap];
  [populationRaster setZoomFactor: zf];
  [populationRaster setWidth: [epdSwarm getWorldXSize] Height: [epdSwarm getWorldYSize]];
  [populationRaster setWindowTitle: "EPD Population"];
  [populationRaster drawSelf];
  [populationRaster pack];

  //create a raster object for displaying cell cooperation and relatedness levels
  worldRaster=[ZoomRaster create: modelZone];
  [worldRaster setColormap: worldColourMap];
  [worldRaster setZoomFactor: zf];
#ifdef testcard
  [worldRaster setWidth: 11 Height: 11];
#else
  [worldRaster setWidth: [epdSwarm getWorldXSize] Height: [epdSwarm getWorldYSize]];
#endif
  [worldRaster setWindowTitle: "EPD World"];
  [worldRaster drawSelf];
  [worldRaster pack];

  //create a display object for cell population densities
  populationValueDisplay=[Value2dDisplay createBegin: [self getZone]];
  [populationValueDisplay setDisplayWidget: populationRaster colormap: populationColourMap];
  [populationValueDisplay setDiscrete2dToDisplay: [epdSwarm getPopulationDisplay]];
  populationValueDisplay=[populationValueDisplay createEnd];
  [populationValueDisplay setDisplayMappingM: 1 C: 0];

  //create a display object for cell cooperation and relatedness levels
  worldValueDisplay=[Value2dDisplay createBegin: [self getZone]];
  [worldValueDisplay setDisplayWidget: worldRaster colormap: worldColourMap];
  [worldValueDisplay setDiscrete2dToDisplay: [epdSwarm getWorldDisplay]];
  worldValueDisplay=[worldValueDisplay createEnd];
  [worldValueDisplay setDisplayMappingM: 1 C: 0];

  //create a graph object to display global cooperation and relatedness levels
  coopGraph=[EZGraph createBegin: [self getZone]];
  [coopGraph setTitle: "Cooperation & Relatedness vs time"];
  [coopGraph setAxisLabelsX: "time" Y: "level (%)"];
  coopGraph=[coopGraph createEnd];
  [coopGraph createSequence: "Cooperation level" withFeedFrom: [epdSwarm getWorld] andSelector: M(getCoopLevel)];
  [coopGraph createSequence: "Global relatedness" withFeedFrom: [epdSwarm getWorld] andSelector: M(getGlobalRelatedness)];

  //create a graph object to display allele frequencies in the gene pool
  alleleGraph=[EZGraph createBegin: [self getZone]];
  [alleleGraph setTitle: "Allele frequencies in population"];
  [alleleGraph setAxisLabelsX: "time" Y: "Level"];
  alleleGraph=[alleleGraph createEnd];
  [alleleGraph createSequence: "Total population" withFeedFrom: [epdSwarm getWorld] andSelector: M(getWorldPopulation)];
  #ifdef pure_kin_selection
    [alleleGraph createSequence: "C allele (locus 0)" withFeedFrom: [[epdSwarm getWorld] getAlleleFrequency: 0] andSelector: M(getIntData)];
    [alleleGraph createSequence: "C allele (locus 1)" withFeedFrom: [[epdSwarm getWorld] getAlleleFrequency: 1] andSelector: M(getIntData)];
  #else
    [alleleGraph createSequence: "Friendly allele" withFeedFrom: [[epdSwarm getWorld] getAlleleFrequency: 0] andSelector: M(getIntData)];
    [alleleGraph createSequence: "Constructive allele" withFeedFrom: [[epdSwarm getWorld] getAlleleFrequency: 1] andSelector: M(getIntData)];
    [alleleGraph createSequence: "Merciful allele" withFeedFrom: [[epdSwarm getWorld] getAlleleFrequency: 2] andSelector: M(getIntData)];
    [alleleGraph createSequence: "Forgiving allele" withFeedFrom: [[epdSwarm getWorld] getAlleleFrequency: 3] andSelector: M(getIntData)];
    [alleleGraph createSequence: "Dovish allele" withFeedFrom: [[epdSwarm getWorld] getAlleleFrequency: 4] andSelector: M(getIntData)];
  #endif

  //create a graph object to display allele frequencies in the gene pool
  strategyGraph=[EZGraph createBegin: [self getZone]];
  [strategyGraph setTitle: "Strategy frequencies in population"];
  [strategyGraph setAxisLabelsX: "time" Y: "Level"];
  strategyGraph=[strategyGraph createEnd];
  [strategyGraph createSequence: "SVE" withFeedFrom: [[epdSwarm getWorld] getStrategyFrequency: 0] andSelector: M(getIntData)];
  [strategyGraph createSequence: "SVM" withFeedFrom: [[epdSwarm getWorld] getStrategyFrequency: 1] andSelector: M(getIntData)];
  [strategyGraph createSequence: "SFE" withFeedFrom: [[epdSwarm getWorld] getStrategyFrequency: 2] andSelector: M(getIntData)];
  [strategyGraph createSequence: "SFM" withFeedFrom: [[epdSwarm getWorld] getStrategyFrequency: 3] andSelector: M(getIntData)];
  [strategyGraph createSequence: "FVE" withFeedFrom: [[epdSwarm getWorld] getStrategyFrequency: 4] andSelector: M(getIntData)];
  [strategyGraph createSequence: "FVM" withFeedFrom: [[epdSwarm getWorld] getStrategyFrequency: 5] andSelector: M(getIntData)];
  [strategyGraph createSequence: "FFE" withFeedFrom: [[epdSwarm getWorld] getStrategyFrequency: 6] andSelector: M(getIntData)];
  [strategyGraph createSequence: "FFM" withFeedFrom: [[epdSwarm getWorld] getStrategyFrequency: 7] andSelector: M(getIntData)];

  return self;
}

-buildActions
{
  [super buildActions];

  //create the model Swarm's actions
  [epdSwarm buildActions];

  //create the action group to update the graphs and displays, and respond to user events
  displayActions=[ActionGroup create: [self getZone]];
  [displayActions createActionTo: worldValueDisplay message: M(display)];
  [displayActions createActionTo: populationValueDisplay message: M(display)];
  [displayActions createActionTo: worldRaster message: M(drawSelf)];
  [displayActions createActionTo: populationRaster message: M(drawSelf)];
  [displayActions createActionTo: coopGraph message: M(step)];
  [displayActions createActionTo: alleleGraph message: M(step)];
  [displayActions createActionTo: strategyGraph message: M(step)];
  [displayActions createActionTo: actionCache message: M(doTkEvents)];

  //create the schedule to execute the action group with a certain display frequency
  displaySchedule=[Schedule createBegin: [self getZone]];
  [displaySchedule setRepeatInterval: displayFrequency];
  displaySchedule=[displaySchedule createEnd];

  //schedule the action group
  [displaySchedule at: 0 createAction: displayActions];

  return self;
}

-activateIn: (id)swarmContext
{
  [super activateIn: swarmContext];

  [epdSwarm activateIn: self];

  [displaySchedule activateIn: self];

  return [self getSwarmActivity];
}

@end
