//Copyright Simon Tokumine 2003. Freely distributable under the GNU General Public Licence

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * @author 	S. Tokumine
 * @date	19-Aug-2003
 * @time	16:13:03
 * @file	ColorPicker.java
 * 
 * @desc In charge of getting user input on the colours to include in the gradient
 *
 */
public class ColorPicker extends JPanel implements ActionListener {

	private ArrayList colorList; //shared list of colours
	private JComboBox colorCombo; //drop down list
	private JLabel color;
	//gets coloured the same colour as that whcih is chosen
	private GradientDisp gDisp; //gradient display
	private MainPanel mainPanel; //mainpanel
	private boolean fileLoaded = false; //flags if a file is loaded
	private SlidePanel slidePanel; //controls
	private StatusBar statusBar; //ok...

	/**
	 * constructor sets up combobox and borders.
	 */
	public ColorPicker(ArrayList colorList_in, StatusBar statusBar_in) {
		super();

		colorList = colorList_in;
		statusBar = statusBar_in;

		//Add border around the combobox.
		setBorder(
			BorderFactory.createCompoundBorder(
				BorderFactory.createTitledBorder("2) Select each colour: "),
				BorderFactory.createEmptyBorder(0, 0, 0, 0)));

		//set up color label
		color = new JLabel("", JLabel.CENTER);
		color.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
		color.setBackground(Color.WHITE);
		color.setOpaque(true);
		color.setPreferredSize(new Dimension(70, 20));

		//set up the combo box
		colorCombo = new JComboBox();
		colorCombo.setPreferredSize(new Dimension(70, 20));

		//must initialise it for it to work!

		//add components to the frame
		setLayout(new FlowLayout());
		add(colorCombo);
		add(color);
	}

	/**
	 * Dirty link to slider controls
	 * @param slidePanel_in
	 */
	public void setSlider(SlidePanel slidePanel_in) {
		slidePanel = slidePanel_in;
	}

	/**
	 * if file loaded, sets flag and sets up key
	 *
	 */
	public void fileLoaded() {
		mainPanel.setKeyP(gDisp.createPKey());
		fileLoaded = true;
	}

	/**
	 * dirty link to the main panel
	 * @param mainPanel_in
	 */
	public void setMainP(MainPanel mainPanel_in) {
		mainPanel = mainPanel_in;
	}

	/**
	 * set up gradient display link
	 */
	public void setGDisp(GradientDisp gradientDisp_in) {
		gDisp = gradientDisp_in;
	}

	/**
	 * Initialise the colour picker with a sized combobox representing the
	 * numebr of colours specified by user
	 * @param number Number of colours in gradient
	 */
	public void initPicker(int number) {
		//reset combobox
		colorCombo.removeActionListener(this);
		colorCombo.removeAllItems();

		//populate combobox with numbers
		for (int i = 0; i < number; i++) {
			colorCombo.addItem(Integer.toString(i + 1));
		}

		//set background of label to white and set
		//up actionlistener
		color.setBackground(Color.WHITE);
		colorCombo.addActionListener(this);

		//reset gradient display to white
		gDisp.colorSet();
	}

	/** 
	 * sets up action to be performed when an item is chosen in the combobox
	 * JColourchooser gets a colour, sets the label to that colour, and adds it to the colourlist
	 * The pallete is set, and the gradient display is redrawn
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		JComboBox cb = (JComboBox) e.getSource();
		String newSelection = (String) cb.getSelectedItem();
		if (newSelection != null) {

			int index = Integer.parseInt(newSelection);

			//get colour from JColourChooser
			Color newColor =
				JColorChooser.showDialog(
					ColorPicker.this,
					"Choose Gradient Color No." + index,
					(Color) colorList.get(index - 1));

			//set up status bar, pallette and gradient display		
			if (newColor != null && gDisp != null) {
				color.setBackground(newColor);
				statusBar.setStatus(
					"Color "
						+ index
						+ " set to: R="
						+ newColor.getRed()
						+ " G="
						+ newColor.getGreen()
						+ " B="
						+ newColor.getBlue()
						+ ".");

				colorList.remove(index - 1); //remove old and replace with new
				colorList.add(index - 1, newColor);
				gDisp.colorSet();
				gDisp.palleteSet();
				if (fileLoaded == true) {
					mainPanel.setKeyP(gDisp.createPKey());
					slidePanel.printOut();
				}
			}
		}
	}

	/**
	 * set up and send the population density key
	 *
	 */
	public void setKey() {
		if (fileLoaded == true) {
			mainPanel.setKeyP(gDisp.createPKey());
			slidePanel.printOut();
		}
	}
}
