//Copyright Simon Tokumine 2003. Freely distributable under the GNU General Public Licence

/**
 * @author 	S. Tokumine
 * @date	30-Jun-2003
 * @time	10:20:13
 * @file	HeightMapFactory.java
 * 
 * Converts 2D array of doubles between 1 and 0 to greyscale colors based 
 * on a integer  pallette
 */

public class HeightMapFactory {

	int noGreys = 256;
	int[] greyMap = new int[noGreys];

	/**
	 * Constructor initialises graymap pallette
	 */
	public HeightMapFactory() {
		initMap();
	}

	/**
	 * calibrates height mapping greyscale array
	 */
	private void initMap() {
		int Alpha = 255;
		int Red = 0;
		int Green = 0;
		int Blue = 0;

		for (int i = 0; i < noGreys; i++) {
			greyMap[i] =
				(Alpha << 24) | (Red++ << 16) | (Green++ << 8) | Blue++;
		}
	}

	/**
	 * converts a 2D height map into a 1D greyscale array ready
	 * for conversion to an image
	 * @param fitMap 2D map input
	 * @return 1D greyscale map
	 */
	public int[] fit2HeightMap(double[][] fitMap) {
		//System.out.println("map x is : " + fitMap[0].length + " map y is : " + fitMap.length);
		int[][] temp = new int[fitMap.length][fitMap[0].length];
		int[] array1D = new int[fitMap.length*fitMap[0].length];
		int index = 0;
		
		//convert heightmap to a 2D array of greyscale
		for (int i = 0; i < fitMap.length; i++) {
			for (int j = 0; j < fitMap[0].length; j++) {
				temp[i][j] = getGrey(fitMap[i][j]);
			}
		}
		
		//convert 2D greyscale array to 1D array and return
		//NOTE THIS CHOPS OFF THE BUFFER PIXELS
		for (int y = 1; y < temp.length-1; y++) {
			for (int x = 1; x < temp[0].length-1; x++) {
				array1D[index++] = temp[y][x];
			}
		}
		return array1D;
	}
	
	/**
	 * hacks off any floating points after conversion to greyscale
	 * @param height Height value between 1 and 0.
	 * @return	a grey value between 0 and 255 (ARGB)
	 */
	private int getGrey(double height) {
			return greyMap[(int) (height * 255)]; 		
	}												
}
