//Copyright Simon Tokumine 2003. Freely distributable under the GNU General Public Licence

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

/**
 * @author 	S. Tokumine
 * @date	02-Jul-2003
 * @time	12:23:42
 * @file	ImagePanel.java
 * 
 * @desc A simple utility class for images
 *
 */
public class ImagePanel extends JPanel {

	int clickX;
	int clickY;
	int x = 0;
	int y = 0;
	Image test2D = null;
	ScoreMapFactory scoreMapFactory;
	int incX = 0;
	int incY = 0;

	/**
	 * Constructor sets out border
	 */
	public ImagePanel() {
		super();
		setBorder(BorderFactory.createEtchedBorder(1));
	}

	/**
	 * sets image and calls for redraw
	 * @param image_in
	 */
	public void SetImage(Image image_in) {
		test2D = image_in;
		repaint();
	}

	/**
	 * records the point in coordinates where the mouse was clicked within the panel
	 * @param x_in
	 * @param y_in
	 */
	public void setClicked(int x_in, int y_in) {
		clickX = x_in;
		clickY = y_in;
	}

	/**
	 * tests the current X location of the mouse against the 
	 * location the mouse was clicked in order to determine movement left or right
	 * @param xUp
	 */
	public void incrementX(int xUp) {
		if ((clickX - xUp) > 0) {
			scoreMapFactory.moveLeft();
		}
		if ((clickX - xUp) < 0) {
			scoreMapFactory.moveRight();
		}
	}

	/**
	 *  tests the current Y location of the mouse against the 
	 *  location the mouse was clicked in order to determine movement up or down
	 * @param yUp
	 */
	public void incrementY(int yUp) {
		if ((clickY - yUp) > 0) {
			scoreMapFactory.moveUp();
		}
		if ((clickY - yUp) < 0) {
			scoreMapFactory.moveDown();
		}
	}

	/**
	 * simple linking method - dirty
	 * @param scoreMapFactory_in
	 */
	public void setScoreFact(ScoreMapFactory scoreMapFactory_in) {
		scoreMapFactory = scoreMapFactory_in;
	}

	/**
	 * if there's an image set, draw it
	 */
	public void paintComponent(Graphics g) {
		//Make background black
		g.setColor(Color.black);
		g.fillRect(0, 0, getSize().width - 1, getSize().height - 1);
		g.setColor(Color.black);
		if (test2D != null) {
			g.drawImage(test2D, -64, 0, this);
		}
	}
}
