//Copyright James Marshall 2003. Freely distributable under the GNU General Public Licence

class Payoffs {
	public static final int mStrategyLength = 5;
	public static final Strategy[] mStrategies;
	public static double mGameLength;
	public static int mTemptation;
	public static int mReward;
	public static int mPunishment;
	public static int mSuckersPayoff;
	//for holding the calcualted payoffs
	public static final double[][] payOffMatrix = new double[32][32];
	private double bestScore = 0;
	private double worstScore = Double.MAX_VALUE;

	class Strategy {
		public final int[] mStrategy;

		public Strategy(int strategyNumber) {
			String binaryString =
				getBinaryString(strategyNumber, mStrategyLength);
			mStrategy = new int[mStrategyLength];
			int l;
			for (l = 0; l < mStrategyLength; l++) {
				mStrategy[l] =
					Integer
						.valueOf(binaryString.substring(l, l + 1))
						.intValue();
			}
		}
	}
	static {
		mStrategies = new Strategy[(int) Math.pow(2, mStrategyLength)];
	}

	public Payoffs() {
		calculatePayoffs();
	}

	/**
	 * Converts a source integer to a binary string
	 *
	 * @param Source integer (0 <= source < 2^numBits)
	 * @param Number of bits
	 *
	 * @return Binary string
	 *
	 * @throws IllegalArgumentException if source integer cannot be encoded in the specified number of bits
	 *
	 */
	public static String getBinaryString(int sourceInt, int numBits) {
		if (sourceInt < 0 || sourceInt >= Math.pow(2, numBits)) {
			throw new IllegalArgumentException(
				sourceInt + " cannot be encoded in " + numBits + " bits");
		}
		String binaryString;

		binaryString = Integer.toBinaryString(sourceInt);
		if (binaryString.length() < numBits) {
			int l;
			char[] paddingBits = new char[numBits - binaryString.length()];
			for (l = 0; l < numBits - binaryString.length(); l++) {
				paddingBits[l] = '0';
			}
			String paddingString = new String(paddingBits);
			binaryString = paddingString.concat(binaryString);
		}

		return binaryString.substring(binaryString.length() - numBits);
	}

	//	public static void main(String args[])
	//	{
	//		Payoffs payoffs = new Payoffs();
	//		payoffs.calculatePayoffs();
	//		//dont use payoffs.NormaliseMatrix();
	//		//payoffs.printMatrix();
	//	}

	public void calculatePayoffs() {
		int l1, l2;
		for (l1 = 0; l1 < (int) Math.pow(2, mStrategyLength); l1++) {
			mStrategies[l1] = new Strategy(l1);
		}
		// NOTE: strategy indices used in calculating payoffs inverted from those used in EPD because EPD has LSB leftmost, whereas getBinaryString() returns LSB rightmost
		for (l1 = 0; l1 < (int) Math.pow(2, mStrategyLength); l1++) {
			// System.out.println(getBinaryString(l1,mStrategyLength) + ":");
			for (l2 = 0; l2 < (int) Math.pow(2, mStrategyLength); l2++) {
				// System.out.print("  " + getBinaryString(l2,mStrategyLength) + ": ");
				int currentAction,
					opponentsCurrentAction,
					lastAction,
					opponentsLastAction,
					iterations = 1;
				double cumulativePayoff = 0;
				currentAction = mStrategies[l1].mStrategy[4];
				opponentsCurrentAction = mStrategies[l2].mStrategy[4];
				while (iterations <= mGameLength) {
					if (currentAction == 0 && opponentsCurrentAction == 0) {
						//System.out.print("P");
						cumulativePayoff += mPunishment;
					} else if (
						currentAction == 0 && opponentsCurrentAction == 1) {
						//System.out.print("T");
						cumulativePayoff += mTemptation;
					} else if (
						currentAction == 1 && opponentsCurrentAction == 0) {
						//System.out.print("S");
						cumulativePayoff += mSuckersPayoff;
					} else if (
						currentAction == 1 && opponentsCurrentAction == 1) {
						//System.out.print("R");
						cumulativePayoff += mReward;
					} else {
						throw new RuntimeException();
					}
					lastAction = currentAction;
					opponentsLastAction = opponentsCurrentAction;
					if (lastAction == 0 && opponentsLastAction == 0) {
						currentAction = mStrategies[l1].mStrategy[0];
						opponentsCurrentAction = mStrategies[l2].mStrategy[0];
					} else if (lastAction == 0 && opponentsLastAction == 1) {
						currentAction = mStrategies[l1].mStrategy[2];
						opponentsCurrentAction = mStrategies[l2].mStrategy[1];
					} else if (lastAction == 1 && opponentsLastAction == 0) {
						currentAction = mStrategies[l1].mStrategy[1];
						opponentsCurrentAction = mStrategies[l2].mStrategy[2];
					} else if (lastAction == 1 && opponentsLastAction == 1) {
						currentAction = mStrategies[l1].mStrategy[3];
						opponentsCurrentAction = mStrategies[l2].mStrategy[3];
					} else {
						throw new RuntimeException();
					}
					iterations++;
				}
				iterations--;
        if (mGameLength - iterations > 0)
        {
          if (currentAction == 0 && opponentsCurrentAction == 0) {
            //System.out.print("P");
            cumulativePayoff += (double) mPunishment * (mGameLength - iterations);
          } else if (
            currentAction == 0 && opponentsCurrentAction == 1) {
            //System.out.print("T");
            cumulativePayoff += (double) mTemptation  * (mGameLength - iterations);
          } else if (
            currentAction == 1 && opponentsCurrentAction == 0) {
            //System.out.print("S");
            cumulativePayoff += (double) mSuckersPayoff * (mGameLength - iterations);
          } else if (
            currentAction == 1 && opponentsCurrentAction == 1) {
            //System.out.print("R");
            cumulativePayoff += (double) mReward * (mGameLength - iterations);
          } else {
            throw new RuntimeException();
          }
        }
				//System.out.println(" (" + cumulativePayoff +")");
				payOffMatrix[l2][l1] = cumulativePayoff; //record to matrix 
				}
		}
		getBestWorst();
	}

	private void getBestWorst() {
		//find the best and worst scores in the matrix
		//use it to normalise weighted sum result
		for (int i = 0; i < payOffMatrix[1].length; i++) {
			for (int j = 0; j < payOffMatrix.length; j++) {
				//score += payOffMatrix[j][i] * 1; //as if gene is only one existing 
				//score = payOffMatrix[j][i];
				if (payOffMatrix[j][i] > bestScore) {
					bestScore = payOffMatrix[j][i];
				}
				if (payOffMatrix[j][i] < worstScore) {
					worstScore = payOffMatrix[j][i];
				}
				//score = 0;
			}
		}
		//	System.out.println("the best payoff is: " + bestScore + " the worst payoff is: " + worstScore);
	}

	//print out for testing
	public void printMatrix() {
		for (int i = 0; i < payOffMatrix[1].length; i++) {
			System.out.println(i + ": ");
			for (int j = 0; j < payOffMatrix.length; j++) {
				System.out.println("\t" + j + ") " + payOffMatrix[j][i]);
			}
		}
	}

	// calculates the weighted sum of the payoffs per gene
	public double calculateFitness(int gene, double[] freq) {

		double score = 0;

		//using the payOffMatrix and the frequency array passed in,
		//for the gene in question calculate cumulative score
		for (int j = 0; j < payOffMatrix.length; j++) {
			score += payOffMatrix[j][gene] * freq[j];
		}

		//use the largest score range to normalise return result between 1 and 0
		return (score - worstScore) / bestScore;

		//			for (int j = 0; j < payOffMatrix.length; j++) {
		//				finalScore += payOffMatrix[j][gene] * freq;
		//			}
		//
		//			return finalScore / bestCumuScore;
		//			/// used to be "/ bestCumuScore" Too much normalised?

	}
}
