//Copyright Simon Tokumine 2003. Freely distributable under the GNU General Public Licence

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

/**
 * @author 	S. Tokumine
 * @date	22-Aug-2003
 * @time	14:59:43
 * @file	PresetColor.java
 * 
 * @desc contains the preset colour buttons and actions
 *
 */
public class PresetColor extends JPanel {

	JButton preset1;
	JButton preset2;
	JButton preset3;
	JButton preset4;
	JButton preset5;
	JButton preset6;

	JPanel topPane;
	JPanel bottomPane;

	GradientDisp gDisp;
	StatusBar statusBar;
	ArrayList colorList;
	ColorPicker colorPicker;
	NumberInput numberPanel;

	//images for buttons
	URL p1uurl;
	URL p2uurl;
	URL p3uurl;
	URL p4uurl;
	URL p5uurl;
	URL p6uurl;

	URL p1durl;
	URL p2durl;
	URL p3durl;
	URL p4durl;
	URL p5durl;
	URL p6durl;

	URL p1ourl;
	URL p2ourl;
	URL p3ourl;
	URL p4ourl;
	URL p5ourl;
	URL p6ourl;

	/**
	 * sets up images, layout, and initialises the buttons
	 */
	public PresetColor(
		GradientDisp gDisp_in,
		StatusBar statusBar_in,
		ThreeColorPicker TCP_in) {
		super();
		setBorder(
			BorderFactory.createCompoundBorder(
				BorderFactory.createTitledBorder(
					"Select a preset colour scheme: "),
				BorderFactory.createEmptyBorder(0, 5, 5, 5)));

		gDisp = gDisp_in;
		statusBar = statusBar_in;

		colorList = gDisp.getColorList();

		colorPicker = TCP_in.getColorPicker();

		//set up link to number panel for button deselct
		numberPanel = TCP_in.setPreset(this);

		topPane = new JPanel();
		bottomPane = new JPanel();

		initButtons();
	}

	/**
	 * initialise buttons and actions
	 */
	private void initButtons() {
		preset1 = new JButton();
		preset2 = new JButton();
		preset3 = new JButton();
		preset4 = new JButton();
		preset5 = new JButton();
		preset6 = new JButton();

		//get icons
		p1uurl = PresetColor.class.getResource("resources/fireup.jpg");
		p2uurl = PresetColor.class.getResource("resources/zebraup.jpg");
		p3uurl = PresetColor.class.getResource("resources/neonup.jpg");
		p4uurl = PresetColor.class.getResource("resources/rainbowup.jpg");
		p5uurl = PresetColor.class.getResource("resources/coolwarmup.jpg");
		p6uurl = PresetColor.class.getResource("resources/earthup.jpg");

		p1durl = PresetColor.class.getResource("resources/firedown.jpg");
		p2durl = PresetColor.class.getResource("resources/zebradown.jpg");
		p3durl = PresetColor.class.getResource("resources/neondown.jpg");
		p4durl = PresetColor.class.getResource("resources/rainbowdown.jpg");
		p5durl = PresetColor.class.getResource("resources/coolwarmdown.jpg");
		p6durl = PresetColor.class.getResource("resources/earthdown.jpg");

		p1ourl = PresetColor.class.getResource("resources/fireover.jpg");
		p2ourl = PresetColor.class.getResource("resources/zebraover.jpg");
		p3ourl = PresetColor.class.getResource("resources/neonover.jpg");
		p4ourl = PresetColor.class.getResource("resources/rainbowover.jpg");
		p5ourl = PresetColor.class.getResource("resources/coolwarmover.jpg");
		p6ourl = PresetColor.class.getResource("resources/earthover.jpg");

		//set normal icon
		preset1.setIcon(new ImageIcon(p1durl));
		preset2.setIcon(new ImageIcon(p2uurl));
		preset3.setIcon(new ImageIcon(p3uurl));
		preset4.setIcon(new ImageIcon(p4uurl));
		preset5.setIcon(new ImageIcon(p5uurl));
		preset6.setIcon(new ImageIcon(p6uurl));

		//set button icon on press
		preset1.setPressedIcon(new ImageIcon(p1durl));
		preset2.setPressedIcon(new ImageIcon(p2durl));
		preset3.setPressedIcon(new ImageIcon(p3durl));
		preset4.setPressedIcon(new ImageIcon(p4durl));
		preset5.setPressedIcon(new ImageIcon(p5durl));
		preset6.setPressedIcon(new ImageIcon(p6durl));

		//set up the rollover icons
		preset1.setRolloverEnabled(true);
		preset2.setRolloverEnabled(true);
		preset3.setRolloverEnabled(true);
		preset4.setRolloverEnabled(true);
		preset5.setRolloverEnabled(true);
		preset6.setRolloverEnabled(true);

		preset1.setRolloverIcon(new ImageIcon(p1durl));
		preset2.setRolloverIcon(new ImageIcon(p2ourl));
		preset3.setRolloverIcon(new ImageIcon(p3ourl));
		preset4.setRolloverIcon(new ImageIcon(p4ourl));
		preset5.setRolloverIcon(new ImageIcon(p5ourl));
		preset6.setRolloverIcon(new ImageIcon(p6ourl));

		//size buttons
		preset1.setPreferredSize(new Dimension(83, 58));
		preset2.setPreferredSize(new Dimension(83, 58));
		preset3.setPreferredSize(new Dimension(83, 58));
		preset4.setPreferredSize(new Dimension(83, 58));
		preset5.setPreferredSize(new Dimension(83, 58));
		preset6.setPreferredSize(new Dimension(83, 58));

		preset1.setBorderPainted(false);
		preset2.setBorderPainted(false);
		preset3.setBorderPainted(false);
		preset4.setBorderPainted(false);
		preset5.setBorderPainted(false);
		preset6.setBorderPainted(false);

		//sizepanels
		topPane.setPreferredSize(new Dimension(270, 65));
		bottomPane.setPreferredSize(new Dimension(270, 65));

		//add buttons to the panels
		topPane.setLayout(new FlowLayout(FlowLayout.CENTER)); //, 50, 0))//;
		bottomPane.setLayout(new FlowLayout(FlowLayout.CENTER)); //, 50, 0))//;
		topPane.add(preset1 /*, BorderLayout.WEST*/
		);
		topPane.add(preset2 /*, BorderLayout.CENTER*/
		);
		topPane.add(preset3 /*, BorderLayout.EAST*/
		);
		bottomPane.add(preset4 /*, BorderLayout.WEST*/
		);
		bottomPane.add(preset5 /*, BorderLayout.CENTER*/
		);
		bottomPane.add(preset6 /*, BorderLayout.EAST*/
		);

		//this is for cross platform button aesthetics
		preset1.setBackground(new Color(236, 233, 216));
		preset2.setBackground(new Color(236, 233, 216));
		preset3.setBackground(new Color(236, 233, 216));
		preset4.setBackground(new Color(236, 233, 216));
		preset5.setBackground(new Color(236, 233, 216));
		preset6.setBackground(new Color(236, 233, 216));

		//add them to the panel
		this.add(topPane, BorderLayout.PAGE_START);
		this.add(bottomPane, BorderLayout.PAGE_END);

		//this is for cross platform button aesthetics
		topPane.setBackground(new Color(236, 233, 216));
		bottomPane.setBackground(new Color(236, 233, 216));

		//add Event listeners
		preset1.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				preset1Press(evt);
			}
		});

		preset2.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				preset2Press(evt);
			}
		});

		preset3.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				preset3Press(evt);
			}
		});

		preset4.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				preset4Press(evt);
			}
		});

		preset5.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				preset5Press(evt);
			}
		});

		preset6.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				preset6Press(evt);
			}
		});

	}

	/**
	 *the preset button methods
	 *number 1 is the default
	 */
	private void preset1Press(ActionEvent evt) {
		numberPanel.setNumber(4);
		colorList.clear();
		colorList.add(Color.BLACK);
		colorList.add(Color.RED);
		colorList.add(Color.ORANGE);
		colorList.add(Color.YELLOW);
		colorList.add(Color.WHITE);
		gDisp.colorSet(); //set display
		gDisp.palleteSet(); //create and set pallette
		colorPicker.setKey(); //create and set key
		statusBar.setStatus("Default \"Fire\" colour scheme selected");
		resetButtons(); //reset all buttons to "up"
		preset1Down(); //and press this buttons "in"
		//set up rollovers to have no effect
		preset1.setRolloverIcon(new ImageIcon(p1durl));
	}

	//number 2 is zebra
	private void preset2Press(ActionEvent evt) {
		numberPanel.setNumber(7);
		colorList.clear();
		colorList.add(Color.BLACK);
		colorList.add(Color.WHITE);
		colorList.add(Color.BLACK);
		colorList.add(Color.WHITE);
		colorList.add(Color.BLACK);
		colorList.add(Color.WHITE);
		colorList.add(Color.BLACK);
		gDisp.colorSet();
		gDisp.palleteSet();
		colorPicker.setKey();
		statusBar.setStatus("\"Zebra\" colour scheme selected");
		resetButtons();
		preset2Down();
		preset2.setRolloverIcon(new ImageIcon(p2durl));
	}
	
	//number 3 is neon contours
	private void preset3Press(ActionEvent evt) {
		numberPanel.setNumber(8);
		colorList.clear();
		colorList.add(Color.BLACK);
		colorList.add(Color.RED);
		colorList.add(Color.BLACK);
		colorList.add(Color.GREEN);
		colorList.add(Color.BLACK);
		colorList.add(Color.BLUE);
		colorList.add(Color.BLACK);
		colorList.add(Color.WHITE);
		gDisp.colorSet();
		gDisp.palleteSet();
		colorPicker.setKey();
		statusBar.setStatus("\"Neon Contour\" colour scheme selected");
		resetButtons();
		preset3Down();
		preset3.setRolloverIcon(new ImageIcon(p3durl));
	}

	//number 4 is rainbow
	private void preset4Press(ActionEvent evt) {
		numberPanel.setNumber(8);
		colorList.clear();
		colorList.add(Color.BLACK);
		colorList.add(Color.RED);
		colorList.add(Color.ORANGE);
		colorList.add(Color.YELLOW);
		colorList.add(Color.GREEN);
		colorList.add(Color.BLUE);
		colorList.add(new Color(51, 0, 153));
		colorList.add(new Color(153, 0, 153));
		gDisp.colorSet();
		gDisp.palleteSet();
		colorPicker.setKey();
		statusBar.setStatus("\"Rainbow\" colour scheme selected");
		resetButtons();
		preset4Down();
		preset4.setRolloverIcon(new ImageIcon(p4durl));
	}

	//number 5 is cold hot	
	private void preset5Press(ActionEvent evt) {
		numberPanel.setNumber(7);
		colorList.clear();
		colorList.add(Color.BLACK);
		colorList.add(Color.BLUE);
		colorList.add(new Color(204, 204, 255));
		colorList.add(Color.RED);
		colorList.add(Color.ORANGE);
		colorList.add(Color.YELLOW);
		colorList.add(Color.WHITE);
		gDisp.colorSet();
		gDisp.palleteSet();
		colorPicker.setKey();
		statusBar.setStatus("\"Cool-Warm\" colour scheme selected");
		resetButtons();
		preset5Down();
		preset5.setRolloverIcon(new ImageIcon(p5durl));
	}

	//number 6 is Earth	
	private void preset6Press(ActionEvent evt) {
		numberPanel.setNumber(7);
		colorList.clear();
		colorList.add(Color.BLACK);
		colorList.add(new Color(153, 102, 0));
		colorList.add(new Color(204, 255, 0));
		colorList.add(Color.GREEN);
		colorList.add(new Color(204, 255, 204));
		colorList.add(new Color(0, 153, 204));
		colorList.add(new Color(0, 102, 255));
		gDisp.colorSet();
		gDisp.palleteSet();
		colorPicker.setKey();
		statusBar.setStatus("\"Earth\" colour scheme selected");
		resetButtons();
		preset6Down();
		preset6.setRolloverIcon(new ImageIcon(p6durl));
	}

	//reset button icons to up (and their rollovers)
	public void resetButtons() {
		preset1.setIcon(new ImageIcon(p1uurl));
		preset2.setIcon(new ImageIcon(p2uurl));
		preset3.setIcon(new ImageIcon(p3uurl));
		preset4.setIcon(new ImageIcon(p4uurl));
		preset5.setIcon(new ImageIcon(p5uurl));
		preset6.setIcon(new ImageIcon(p6uurl));

		preset1.setRolloverIcon(new ImageIcon(p1ourl));
		preset2.setRolloverIcon(new ImageIcon(p2ourl));
		preset3.setRolloverIcon(new ImageIcon(p3ourl));
		preset4.setRolloverIcon(new ImageIcon(p4ourl));
		preset5.setRolloverIcon(new ImageIcon(p5ourl));
		preset6.setRolloverIcon(new ImageIcon(p6ourl));
	}

	//set button icons to down
	private void preset1Down() {
		preset1.setIcon(new ImageIcon(p1durl));
	}
	private void preset2Down() {
		preset2.setIcon(new ImageIcon(p2durl));
	}
	private void preset3Down() {
		preset3.setIcon(new ImageIcon(p3durl));
	}
	private void preset4Down() {
		preset4.setIcon(new ImageIcon(p4durl));
	}
	private void preset5Down() {
		preset5.setIcon(new ImageIcon(p5durl));
	}
	private void preset6Down() {
		preset6.setIcon(new ImageIcon(p6durl));
	}

	//this is all for cross platform button aesthetics
	public void paintComponent(Graphics g) {

		//Make background grey
		g.setColor(new Color(236, 233, 216));
		g.fillRect(2, 17, getSize().width - 6, getSize().height - 20);
		g.setColor(Color.black);
	}
}
