//Copyright Simon Tokumine 2003. Freely distributable under the GNU General Public Licence

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * @author 	S. Tokumine
 * @date	31-Aug-2003
 * @time	17:31:05
 * @file	SSMPanel.java
 * 
 * @desc This class contains and creates the Search space matrix representation
 * panel inthe tabbed panes. It also monitors mouse movement and refresh of it
 *
 */
public class SSMPanel
	extends JPanel
	implements MouseMotionListener, MouseListener {

	ScoreMapFactory scoreMapFactory;
	SlidePanel slidePanel;
	JPanel matrixPane = new JPanel(); //internal panel for SSM depiction
	int[][] sSMatrix;

	int clickX;
	int clickY;
	int incX;
	int incY;

	JLabel testLabel = new JLabel("");
	JPanel bottomPanel;

	/**
	 * creates SSM display and sets up links
	 */
	public SSMPanel(
		ScoreMapFactory scoreMapFactory_in,
		SlidePanel slidePanel_in) {
		super();
		scoreMapFactory = scoreMapFactory_in;
		slidePanel = slidePanel_in;

		//set up border
		setBorder(
			BorderFactory.createCompoundBorder(
				BorderFactory.createTitledBorder(
					"Search Space Matrix (Click and drag to change): "),
				BorderFactory.createEmptyBorder(5, 5, 5, 5)));

		//make frame around the matrix window pane
		matrixPane.setBorder(
			BorderFactory.createCompoundBorder(
				BorderFactory.createLineBorder(Color.GRAY, 1),
				BorderFactory.createEmptyBorder(10, 5, 5, 5)));

		matrixPane.setBackground(Color.LIGHT_GRAY);

		matrixPane.setPreferredSize(new Dimension(500, 400));

		//set up boxlayout (lay out top to bottom
		matrixPane.setLayout(new BoxLayout(matrixPane, BoxLayout.Y_AXIS));

		//add matrix frame to ssmpanel
		add(BorderLayout.CENTER, matrixPane);

		//register with scoremapfactory
		scoreMapFactory.setSSMPanel(this);

		//initialise search space Maxtrix Visualisation
		sSMatrix = scoreMapFactory.getSSM();
		bottomPanel = createTicks(sSMatrix[0].length);
		createMatrix(); //creates display

		//create size for update
		testLabel.setSize(0, 0);

	}

	//	add mouse & mouse motion listeners
	public void initMouse() {
		matrixPane.addMouseListener(this);
		matrixPane.addMouseMotionListener(this);
		matrixPane.setCursor(new Cursor(Cursor.HAND_CURSOR));
		matrixPane.setToolTipText("Click & Drag to scroll the Matrix");

	}

	//creates matrix by creating rows of labels
	public void createMatrix() {

		//clear panel
		matrixPane.removeAll();

		//get search space matrix
		sSMatrix = scoreMapFactory.getSSM();

		for (int i = 0; i < sSMatrix.length; i++) {
			matrixPane.add(createTicks(sSMatrix[i].length));
			matrixPane.add(createRow(sSMatrix[i]));
		}

		matrixPane.add(bottomPanel);
		matrixPane.add(testLabel);
		testLabel.setText("."); //weirdly needed to update
		matrixPane.remove(testLabel);
	}

	//create a row of ticks from the length of the ssmatrix
	private JPanel createTicks(int noTicks) {
		JPanel tickPanel = new JPanel();
		tickPanel.setLayout(new FlowLayout(FlowLayout.CENTER, 65, 0));
		//for tick spacing	
		tickPanel.setBackground(Color.LIGHT_GRAY);

		//build up tickpanel
		for (int j = 0; j < noTicks; j++) {
			JLabel vertLabel = new JLabel("", JLabel.CENTER);
			vertLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
			vertLabel.setBackground(Color.BLACK);
			vertLabel.setOpaque(true);
			vertLabel.setPreferredSize(new Dimension(3, 10));
			tickPanel.add(vertLabel);
		}

		return tickPanel;
	}

	//create a row of labels from a row of the ssm passed in
	private JPanel createRow(int[] rowNumbers) {

		JPanel rowPanel = new JPanel();
		rowPanel.setBackground(Color.LIGHT_GRAY);
		rowPanel.setLayout(new FlowLayout());

		//build up the components by cycling through the row (making sure to add tick lines)
		for (int i = 0; i < rowNumbers.length; i++) {

			//ticks
			JLabel lineLabel = new JLabel("", JLabel.CENTER);
			lineLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
			lineLabel.setBackground(Color.BLACK);
			lineLabel.setOpaque(true);
			lineLabel.setPreferredSize(new Dimension(10, 3));

			rowPanel.add(lineLabel);

			//chromasome
			JLabel numberLabel =
				new JLabel(getChromosome(rowNumbers[(i + 3) % 4]), JLabel.CENTER); // James: had to hack this to fix out-by-one error in X-axis
			numberLabel.setBorder(
				BorderFactory.createLineBorder(Color.BLACK, 1));
			numberLabel.setBackground(Color.white);
			numberLabel.setOpaque(true);
			numberLabel.setPreferredSize(new Dimension(50, 15));

			rowPanel.add(numberLabel);
		}

		//add last line
		JLabel lineLabel = new JLabel("", JLabel.CENTER);
		lineLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
		lineLabel.setBackground(Color.BLACK);
		lineLabel.setOpaque(true);
		lineLabel.setPreferredSize(new Dimension(10, 3));

		rowPanel.add(lineLabel);

		return rowPanel;
	}

	//returns actual chromasome from the chromasome reference number used in the SSM.
	private String getChromosome(int chromaID) {

		switch (chromaID) {
			case 0 :
				return "BBBBB";

			case 1 :
				return "ABBBB";

			case 2 :
				return "BABBB";

			case 3 :
				return "AABBB";

			case 4 :
				return "BBABB";

			case 5 :
				return "ABABB";

			case 6 :
				return "BAABB";

			case 7 :
				return "AAABB";

			case 8 :
				return "BBBAB";

			case 9 :
				return "ABBAB";

			case 10 :
				return "BABAB";

			case 11 :
				return "AABAB";

			case 12 :
				return "BBAAB";

			case 13 :
				return "ABAAB";

			case 14 :
				return "BAAAB";

			case 15 :
				return "AAAAB";

			case 16 :
				return "BBBBA";

			case 17 :
				return "ABBBA";

			case 18 :
				return "BABBA";

			case 19 :
				return "AABBA";

			case 20 :
				return "BBABA";

			case 21 :
				return "ABABA";

			case 22 :
				return "BAABA";

			case 23 :
				return "AAABA";

			case 24 :
				return "BBBAA";

			case 25 :
				return "ABBAA";

			case 26 :
				return "BABAA";

			case 27 :
				return "AABAA";

			case 28 :
				return "BBAAA";

			case 29 :
				return "ABAAA";

			case 30 :
				return "BAAAA";

			case 31 :
				return "AAAAA";

			default :
				return "BBBBB";

		}

	}

	/**
	 * mouse movement detection is the same as in the main panel setup
	 */
	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mouseClicked(java.awt.event.MouseEvent)
	 */
	public void mouseClicked(MouseEvent e) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mouseEntered(java.awt.event.MouseEvent)
	 */
	public void mouseEntered(MouseEvent e) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mouseExited(java.awt.event.MouseEvent)
	 */
	public void mouseExited(MouseEvent e) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mousePressed(java.awt.event.MouseEvent)
	 */
	public void mousePressed(MouseEvent e) {
		// TODO Auto-generated method stub
		clickX = e.getX();
		clickY = e.getY();
		matrixPane.setCursor(new Cursor(Cursor.MOVE_CURSOR));
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mouseReleased(java.awt.event.MouseEvent)
	 */
	public void mouseReleased(MouseEvent e) {
		// TODO Auto-generated method stub
		clickX = 0;
		clickY = 0;
		scoreMapFactory.setZero();
		testLabel.setText("");
		matrixPane.setCursor(new Cursor(Cursor.HAND_CURSOR));

	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseMotionListener#mouseDragged(java.awt.event.MouseEvent)
	 */
	public void mouseDragged(MouseEvent e) {
		// TODO Auto-generated method stub

		if (e.getX() % 3 == 0) {

			if ((clickX - e.getX()) > 0) {
				//System.out.println("moving left");
				scoreMapFactory.moveLeft();
			}
			if ((clickX - e.getX()) < 0) {
				//	System.out.println("moving right");
				scoreMapFactory.moveRight();
			}
		}
		if (e.getY() % 3 == 0) {

			if ((clickY - e.getY()) > 0) {
				//	System.out.println("moving up");
				scoreMapFactory.moveUp();
			}
			if ((clickY - e.getY()) < 0) {
				//	System.out.println("moving down");
				scoreMapFactory.moveDown();
			}

			clickX = e.getX();
			clickY = e.getY();

			testLabel.setText("");
		}
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseMotionListener#mouseMoved(java.awt.event.MouseEvent)
	 */
	public void mouseMoved(MouseEvent e) {
		// TODO Auto-generated method stub

	}
}
