//EPDSwarm.h EPD
//Copyright James Marshall 1998-2004. Freely distributable under the GNU General Public Licence

#import "EPDWorld.h"

#import <objectbase/Swarm.h>
#import <space.h>
#import <activity.h>
#import <random.h>
#import <collections.h>
#import <simtools.h>
#import "EPDDefines.h"

//#define debug

@interface Payoffs: SwarmObject
{
  int AAPayoff, ABPayoff, BAPayoff, BBPayoff;
}

-create;
-(int)getAAPayoff;
-(int)getABPayoff;
-(int)getBAPayoff;
-(int)getBBPayoff;

@end

@interface EPDSwarm: Swarm
{
  int worldXsize, worldYsize;
  int maxAgents, maxLocalAgents, startAgents, strategyLength, strategyNumber;
  int startEnergy, livingCost;
  int endTime;
  double deathProbability, moveProbability, defectorProbability;
  float mutationRate, crossProbability;
  id payoffs;

  id world;
  id populationDisplay, worldDisplay;
//  id <ListIndex> allAgents;
  id allAgents;
  id modelStep;
  id modelSchedule;
}

+createBegin: (id) aZone;
-createEnd;
-(void)drop;
-buildObjects;
-buildActions;
-activateIn: (id) swarmContext;
-getPopulationDisplay;
-getWorldDisplay;
-getWorld;
-(int)getWorldXSize;
-(int)getWorldYSize;
-setMoveProbability: (double) moveProb;
-checkToStop;

@end
