

//#import "Parameters.h"
#import "MyParameter.h"
#import "Bar.h"
#import "Agent.h"
#import "Rule.h"
#import "MovingAverage.h"
#import <random.h>
@implementation Bar

///////////////////////////////////////////////////////
// Tell Bar to do this at the start of a model step
// to do any initialization
-(void) startStep {
  // int choice, i;
  id temp;
  int compareNum = [self getLastAttendance];
  temp = (id) compareNum;
  [rules forEach: M(wasSuccess:): temp];
  //  //	DMSG(1,(stderr,"=> Bar-startStep...\n"))
  	   	attendance = 0;
    
}

// Bar does this at end of step, for any cleanup
// or end of step calculations
-(void) endStep {  

        [myHistory addValue: (double) attendance];

}

///////////////////////////////////////////////////////
// agentArriving
// record that an agent is arriving at the bar

-(void) agentArriving {
	attendance++;
}

//This has been updated to randomly select from equally successful
//strategies.
-(int) getBestActiveStrat: (int*) activeStrat {
  int i, bestNumSuccesses, newNumSuccesses;
  int returnValue;
  int equalGood[20];
  int numGood = 0;
  id o;
  i=0;
  //Find the first active strategy
  while(activeStrat[i] == 0) { i++; }
  returnValue = i;
  equalGood[0] = returnValue;
  numGood++;
  returnValue++;
  o = [myModelSwarm findRuleWithID: i];
  bestNumSuccesses = [o getTimesSuccess];
  for(i=returnValue;i<21;i++) {
    if(activeStrat[i]==1) {
      o = [myModelSwarm findRuleWithID: i];
      newNumSuccesses = [o getTimesSuccess];
      if(newNumSuccesses > bestNumSuccesses) {
	bestNumSuccesses = newNumSuccesses;
	equalGood[0] = i;
	numGood = 1;
      }else if(newNumSuccesses == bestNumSuccesses) {
	equalGood[numGood] = i;
	numGood++;
      }
    }
  }
  numGood--;
  numGood = [uniformIntRand getIntegerWithMin: 0 withMax: numGood];
  returnValue = equalGood[numGood];
  // printf("best strategy is %d, activestrat is %d\n", returnValue, activeStrat[equalGood[numGood]]);
  
  return returnValue;
}

-(unsigned int) decide: (int) strat {
  unsigned int choice;
  id o;
  o = [myModelSwarm findRuleWithID: strat];
  choice = [o choose];
  [o incTimesUsed];
  
  // printf("choose in bar is %d\n", choice);
  if (choice == 1) { [self agentArriving]; }
  return choice;
 
}

/////////////////////////////////////////////////////////
// create the Bar object, and also a RunningAverage object.
// The RunningAverage object can be sent data points,
// and then asked to return the running average, ie, average
// over the last N time steps.
+createBegin: (id) aZone {
        Bar *obj;
	obj = [super createBegin: aZone];
	obj->myHistory = [MovingAverage create: aZone];

	return obj;
}
-(double) getMA {
  return [myHistory getMA];
}
-(void) setupHistory: (unsigned) size {
        [myHistory initWidth: size];
}

/////////////////////////////////////////////////////////
// get/set methods
-(void) setTotalAgents: (int) x { totalAgents = x; }
-(unsigned) getAttendance { return attendance; }

-(void) setStartAttendance: (int) x { [myHistory addValue: (double) x];}

-(double) getRAvgAttendance {
	return [myHistory getAverage];
}
-(double) getCycle: (int) repeatTime {
  return [myHistory getCycle: repeatTime];
}
-(double) getTrend: (int) num withBound: (int) max {
  return [myHistory getTrendNum: num withBound: max];
}
-(double) getPartAttendance: (int) x {
  return [myHistory getPartAverage: x];
}

-(int) getTotalAgents { return totalAgents; }
-(int) getLastAttendance { 
  return (int) [myHistory getLastNum];
}
-(void) setRules: (id) r { rules = r; }
-(void) setModelSwarm: (id) ms { myModelSwarm = ms; }
@end
