/*

FEARLUS Model 0-2 Swarm implementation

Gary Polhill, Macaulay Land Use Research Institute, Aberdeen, UK

DBColormap -- a colormap that stores the text of each of the colours it
creates. I've tried doing this by subclassing from Colormap. That doesn't
work, of course, so now here's one that uses SwarmObject.

*/

#import <gui.h>
#import <collections/StringObject.h>
#import <objectbase/SwarmObject.h>



#define MAXCOLOURS 256		// Get this value from tkobjc/Colormap.h
				// (but don't #import it or you'll have no end
				// of trouble, mark my words).

@interface DBColormap: SwarmObject {
  id <String> coltext[MAXCOLOURS];
				// An array of pointers to the String class
  id cmap;		// The real colour map.
}

// Methods in the Colormap class implementation that don't appear in the
// interface. (Why not?)

-createEnd;

// Methods from the Colormap class, which we'll have to over-ride to make this
// look like it's a colormap.

-(PixelValue *)map;
-(PixelValue)pixelValue: (Color)c;
-(PixelValue)white;
-(PixelValue)black;
-(BOOL)colorIsSet: (Color)c;
-(Color)nextFreeColor;

// Methods for this class.

+createBegin: (id)aZone;
+create: (id)aZone;
-(BOOL)setColor: (Color)c ToGrey: (double)g;
-(BOOL)setColor: (Color)c ToRed: (double)r Green: (double)g Blue: (double)b;
				// Wouldn't have to do these two if I could
				// subclass from Colormap.
-(BOOL)setColor: (Color)c ToName: (const char *)colorName;
-(void)getColor: (Color)c inString: (id <String>)buffer;
-(void)drop;
-(id <Colormap>)getColormap;	// Put this in so things that need a Colormap
				// protocol following class can have one
				// without complaint.

@end











