/*

FEARLUS Model 0-2 Swarm Implementation

Gary Polhill, Macaulay Land Use Research Institute, Aberdeen, UK

Implementation of the DBColormap class

*/

#import "DBColormap.h"

@implementation DBColormap

PHASE(Creating)

/*

createBegin:

Create the colourmap

*/

+createBegin: (id)aZone {
  DBColormap *obj;

  obj = [super createBegin: aZone];
  obj->cmap = [Colormap createBegin: aZone];
  return obj;
}

/*

create:

Just in case, create the colourmap this way, too.

*/

+create: (id)aZone {
  DBColormap *obj;

  obj = [super create: aZone];
  obj->cmap = [Colormap create: aZone];
  return obj;
}

/*

createEnd

Nothing to say about this.

*/

-createEnd {
  [super createEnd];
  cmap = [cmap createEnd];
  return self;
}

PHASE(Using)

/****

  What follows is a load of methods that the Colormap class implements. We'll
  just hand them straight on to that

  ****/

-(PixelValue *)map {
  return [cmap map];
}

-(PixelValue)pixelValue: (Color)c {
  return [cmap pixelValue: c];
}

-(PixelValue)white {
  return [cmap white];
}

-(PixelValue)black {
  return [cmap black];
}

-(BOOL)colorIsSet: (Color)c {
  return [cmap colorIsSet: c];
}

-(Color)nextFreeColor {
  return [cmap nextFreeColor];
}

/****

  Now the methods for this class, which store the colours being passed in.

  ****/


/*

setColor:ToGrey:

Generate a grey level colour. Just call the RGB method with R, G & B equal.

*/

-(BOOL)setColor: (Color)c ToGrey: (double)g {
  return [self setColor: c ToRed: g Green: g Blue: g];
}

/*

setColor:ToRed:Green:Blue:

Generate a colour with no name in the rgb.txt file. Now here, irritatingly,
we'll have to duplicate some of the code in the original Colormap
implementation in order to save the colour in the format "#RRGGBB"

*/

-(BOOL)setColor: (Color)c ToRed: (double)r Green: (double)g Blue: (double)b {
  unsigned ru, gu, bu;
  char colorName[1+2+2+2+1];			  // "#rrggbb\0"

  ru = r * 0xffU;
  gu = g * 0xffU;
  bu = b * 0xffU;

  sprintf (colorName, "#%02x%02x%02x", ru, gu, bu);
  return [self setColor: c ToName: colorName];
}

/*

setColor:ToName:

If the Colormap setColor method succeeds, then store the colour name in the
array.

*/

-(BOOL)setColor: (Color)c ToName: (const char *)colorName {
  BOOL retval;

  if((retval = [cmap setColor: c ToName: colorName])) {
    coltext[c] = [String create: [self getZone] setC: colorName];
  }
  return retval;
}

/*

getColor:inString:

Make a copy of the colour text for the required colour in the string pointer
passed as argument. Assumes that the string pointer has already been created.

*/

-(void)getColor: (Color)c inString: (id <String>)buffer {
  if([cmap colorIsSet: c]) {
    [buffer setC: [coltext[c] getC]];
  }
  else {
    [InvalidArgument raiseEvent: "attempted to access unset color %d\n", c];
  }
}

/*

drop

Delete the colormap database

*/

-(void)drop {
  Color c;

  for(c = 0; c < MAXCOLOURS; c++) {
    if([self colorIsSet: c]) {
      [coltext[c] drop];
    }
  }
  [cmap drop];
  [super drop];
}

/*

getColormap

Return a pointer to the colour map

*/

-(id <Colormap>)getColormap {
  return cmap;
}

@end


