/*

FEARLUS Model 0-2 Swarm Implementation

Gary Polhill, Macaulay Land Use Research Institute, Aberdeen, UK

Hack of EZBin to do bar charts.

EZBin is Copyright (C) 1996-1998 Santa Fe Institute

*/

#import <simtoolsgui/GUIComposite.h>
#import <gui.h>
#import "DBColormap.h"

// EZBin object: used to generate histograms.

@interface EZBar: GUIComposite
{
  BOOL graphics;
  BOOL showAverage;
  BOOL barLabels;
  id  <Histogram> aHisto;
  DBColormap *barColourmap;

  BOOL fileOutput;
  id anOutFile;

  const char *theTitle;
  const char *xLabel;
  const char *yLabel;
  const char *filename;

  double *distribution;
  double *averages;
  double min, max;
  int clean;
  int binNum;
  int count;			// Don't know what this is used for in EZBin. 
				// Here it's used to keep a track of the time.
  int outliers;
  id collection;
  id originalCollection;
  id barZone;
  SEL probedSelector, colourSelector, labelSelector;

  double minval, maxval, average, average2, std;
}

+createBegin: aZone;
-setGraphics: (BOOL)state;
-setFileOutput: (BOOL)state;
-setTitle: (const char *)aTitle; 
-setCollection: (id)aCollection;
-setProbedSelector: (SEL)aSel;

-setOutputFilename: (const char *)aFilename;
-setColourSelector: (SEL)aSel andColourmap: (DBColormap *)cmap;
-setLabelSelector: (SEL)aSel;
-createEnd;

-showAverage;
-showCurrent;

-setAxisLabelsX: (const char *)xl Y: (const char *)yl;

-reset;
-(void) step;

-(double *)getDistribution;

-(int)getBarCount;
-(int)getOutliers;
-(int)getBinNum;

-(double)getMin;
-(double)getMax;
-(double)getAverage;
-(double)getStd;

@end
