
#import <simtools.h>
#import "Rule.h"
#import <analysis.h>
//#import <time.h>
//#include <sys/times.h>
#import "ModelSwarm.h"
//#import "Parameters.h"
#include <misc.h>
#import "MyParameter.h"
#import "Agent.h"
//#import "Rule.h"
//#define TimeDateSz 32
//char StartTime[TimeDateSz], StartDate[TimeDateSz];

@implementation ModelSwarm

//-getParameters { return parameters; }
//-(void) setParameters: (id) p { parameters = p; }
-(id) getAgents { return agents; }
-(id) getTheBar { return theBar; }
-(id) getRules { return rules; }

////////////////////////////////////////////////////////////////////
// This will find an agent with the specified ID.
// returns nil if not found.
-(id) findAgentWithID: (unsigned int) ID {
	id o, num;
	
	num = [agents begin: self];
	while ( (o = [num next]) ) {
		if ( ID == [o getID] )
			break;
	}
	[num drop];
	return o;
}

-(id) findRuleWithID: (unsigned int) ID {
	id o, num = NULL;
	
	num = [rules begin: self ];
	while ( (o = [num next]) ) {
		if ( ID == [o getID] )
			break;
	}
	[num drop];
	return o;
}

//////////////////////////////////////////////////////////////////////
+createBegin: (id) aZone {
	ModelSwarm *obj;
	extern id theModel;
	obj = [super createBegin: aZone];
	obj->numRules = 21;  //This must be correctly hard coded.
	theModel = obj;
	return obj;
}

-createEnd {
	return [super createEnd];
}

///////////////////////////////////////////////////////////////////////
-buildObjects {
	int i, numAgents;
	int memory, numAct, startAtt;
	Agent	*agent;
        Rule *rule;
       
	// create a 'bar'
	theBar = [Bar create: [self getZone]];
	[theBar setupHistory: getInt(arguments,"historyLength")];
	startAtt = getInt(arguments,"startAttendance");
	[theBar setStartAttendance: startAtt];
	[theBar setModelSwarm: self];
  	numAct = getInt(arguments, "numActive");
	memory = getInt(arguments, "historyLength");
	// create a list to hold the agents, and then
	// populate it with agents.
	agents = [List create: [self getZone]];
     //	numAgents = RetUPar("numAgents");	// use macro to get this value
        numAgents = getInt(arguments, "numAgents");
	[theBar setTotalAgents: numAgents];
	for ( i = 0; i < numAgents; ++i ) {
		agent = [Agent createBegin: [self getZone]];
		agent = [agent createEnd];
		[agent setTheBar: theBar];
		[agent setNumActive: numAct];
		[agent setMemoryLen: memory];
		//[agent setModelSwarm];
		[agent setTotalAgents: numAgents];
		[agent initStrats];
	
		[agents addLast: agent];
	}
	rules = [List create: [self getZone]];
	for(i=0; i<numRules; i++) {
	  rule = [Rule createBegin: [self getZone]];
	  rule = [rule createEnd];
	  [rule setTheBar: theBar];
	  [rules addLast: rule];
	}
	[theBar setRules: rules];
	//Create the output file
	if(getInt(arguments,"run")!=-1) //If run not equal to -1, use it
	  sprintf(reportFileName, "report%d", getInt(arguments, "run"));
	else //otherwise, use time(0).  Include misc.h
	  sprintf(reportFileName, "report%d", (int)time(0));
	
	reportFILE = fopen(reportFileName, "w+");
	fprintf(reportFILE, "num agents = %d \n", numAgents);
	fprintf(reportFILE, "start attendance = %d\n",startAtt);
	fprintf(reportFILE, "number of active = %d\n", numAct);
	fprintf(reportFILE, "memory length = %d\n", memory);

	return self;
}

-(FILE *) getReportFile { return reportFILE; }


//////////////////////////////////////////////////////////////////////
-buildActions {
	[super buildActions];
  
	// create actions to be done, in specified order.
	modelActions = [ActionGroup create: [self getZone]];
	[modelActions createActionTo:      theBar   message: M(startStep)];
	[modelActions createActionForEach: agents   message: M(makeChoice)];
	[modelActions createActionForEach: agents   message: M(updateStrategies)];
	[modelActions createActionTo:      theBar   message: M(endStep)];
	[modelActions createActionTo:      self     message: M(stepReport)];

	// schedule the actions to occur starting at 0, each step.
	modelSchedule = [Schedule createBegin: [self getZone]];
	[modelSchedule setRepeatInterval: 1];
	modelSchedule = [modelSchedule createEnd];
	[modelSchedule at: 0 createAction: modelActions];

	return self;
}

// boilerplate -- no need to change for simple models
-activateIn: (id) swarmContext {
	[super activateIn: swarmContext];
	[modelSchedule activateIn: self];
	return [self getSwarmActivity];
}

//////////////////////////////////////////////////////////////////
// stepReport
// Print info to the reportFILE.

-stepReport {
//  	if ( getCurrentTime() % 1 == 0 ) {
//  		fprintf( reportFILE,
//  			 " %5lu %4d %7.2f\n", getCurrentTime(), 
//  			 [theBar getAttendance], [theBar getRAvgAttendance] );
//  	}
  fprintf(reportFILE, "%d    %7.2f\n", [theBar getAttendance],
					       [theBar getRAvgAttendance]);
	  fflush(reportFILE);
	return self;
}

@end
