#import "MovingAverage.h"


@implementation MovingAverage


-initWidth: (int) w
{
  int i;
  width=w;
  maInputs=[[self getZone] allocBlock: w * sizeof(double) ];
  for(i=0; i < w; i++)
    {
      maInputs[i] = 0;
    }
  numInputs=0;
  sumOfInputs=0;
  arrayPosition=0;
  uncorrectedSum=0;
 
  return self;			   
}

-(int) getNumInputs
{
  return numInputs;

}

-(double) getCycle: (int) repeatTime 
{
  //For get cycle, I choose to return the oldest recorded attendence when
  //repeatTime is too large.  For this purpose, repeatTime should not be
  //set higher than width, or this becomes meaningless.
  int index;
  index=repeatTime;
  if(numInputs < repeatTime)
  {  index=numInputs-1;
  // printf("repeatTime higher than numInputs, set index at %d",index);
  }else if(width < repeatTime) {
     index=width-1;
     printf("uh-oh, repeatTime higher than width!! index set at %d", index);
  }else{
    if(numInputs < width) { index = numInputs-repeatTime; }
    else{ index = width-repeatTime-1; }
  }
  if((index < 0) || (index >= width)) {printf("error, index is %d",index);}
  return maInputs[index];
}

 
  

-(double) getMA;
{
  double movingAverage;
  if (numInputs == 0) return 0;

  else if (numInputs < width)
    {
      movingAverage=  (double)sumOfInputs / numInputs;
    }
  else
    {
      movingAverage = (double)sumOfInputs / width;
    }
  //  printf( "Object: ma=%f  sumOfInput: %f numInputs: %d \n",movingAverage, sumOfInputs, numInputs);
  return movingAverage;
}

-(double) getTrendNum: (int) num withBound: (int) max
{
  //This routine gets the "trend" over the past "num" numbers.
  //This is bounded by zero and max where max is the total number of agents.

    double totalTrend=0;
    double returnValue=0.0;
    int start, stop, i;
    if(numInputs<1){ returnValue = 5;
    }else if(numInputs == 1) {returnValue = maInputs[0];
    }else{ 
      if(numInputs < width) {
        stop = numInputs;
      }else{stop = width-1;}
      start=stop-num;
      if(start < 0) { start=0; }
      for(i=(start+1); i<stop; i++) {
       totalTrend=totalTrend+(maInputs[i]-maInputs[i-1]);
    }
    returnValue = maInputs[stop-1]+totalTrend;
    }
while(returnValue < 0) {
  returnValue = (max+1) - returnValue;
}
while(returnValue > max){
  returnValue = returnValue-(max+1);
}
if((returnValue < 0) || (returnValue > max)){
     printf("something wrong.  Return value is %f", returnValue);
}
//    int takeAway, takeFrom, myNum;
//    myNum=num;
//   myIndex = (width + numInputs % width);  
//   if(myNum > width)
//    { 
//      if(numInputs < width)
//      {
//        myNum = numInputs;
//      }else{
//        myNum = width;
//      }
//    }
//   if(numInputs < width)
//     {

//     }else{
//     }
  return returnValue;
} 

-(double) getAverage
{
  if (numInputs ==0) return 0;
  else return (double)uncorrectedSum/numInputs;
}
//This function differs from getAverage in that it allows you to get the
//average of the last x numbers instead of the entire history (up to declared
//size of maInputs).


-(double) getPartAverage: (int) x 
{
  double returnValue = 0.0;
  int myIndex, i;
  int start, stop;
  if(numInputs < width) {
    stop = numInputs - 1;
  }else{ stop = width - 1; }
  // for(i=0; i<=stop; i++) {
    //  printf("num%d %d ", i, (int)maInputs[i]);
    // }
  //  printf("\n");
  myIndex = (width + numInputs % width);
  if(x > width) {
    // printf("number exceeds total in array, returning MovingAverage\n");
    returnValue = [self getAverage];
  }else if(numInputs <= x) {
    returnValue = [self getAverage];
    //  printf("returnValue is %f\n", returnValue);
  }else if((numInputs > x) && (numInputs <= width)) {
    start=numInputs-x;
    stop=numInputs;
    //  printf("numInputs is %d start is %d and stop is %d\n",numInputs,start,stop);
    for(i=(start); i < stop; i++) {
      // printf("num%d is %d", i, (int)maInputs[i]);
      returnValue += maInputs[i];
    }
    //  printf("\n");
    returnValue = returnValue / x;
  }else {
    myIndex = ((width + numInputs) % width) -1;
    //  printf("myIndex = %d\n", myIndex);
    for(i=0; i<x; i++) {
      if(myIndex < 0) {
	myIndex = width-1;
      }
      returnValue += maInputs[myIndex];
      //       printf("num%d %d ", myIndex, (int)maInputs[myIndex]);
      myIndex--;
    }
    //  printf("\n");
    returnValue = returnValue / (double) x;
  }
  return returnValue;
}

-(double) getLastNum 
{
  arrayPosition = ((width + numInputs) % width)-1;
  if(arrayPosition == -1) arrayPosition =13;
  return maInputs[arrayPosition];
} 

-(double) addValue: (double) x;
{
  arrayPosition = (width + numInputs) % width;
  if(numInputs < width)
    {
    sumOfInputs+=x;
    maInputs[arrayPosition]=x;
    }
  else
    {
      sumOfInputs=sumOfInputs - maInputs[arrayPosition] + x ;
      maInputs[arrayPosition]=x;
    }
  numInputs++;

  uncorrectedSum+=x;
  return [self getMA];
}



@end



