#import "MyParameter.h"
#import <objectbase.h>
#import <misc.h> //This is a "multipurpose" include fromt he swarm library.
//It contains header info for C functions atoi, strtod

//These 3 are "convenience" functions that other objects can use to get 
//values out of the MyParamter object

id
makeProbe (id obj, const char *ivarName)
{
  id probe = [VarProbe createBegin: [obj getZone]];
  [probe setProbedClass: [obj getClass]];
  [probe setProbedVariable: ivarName];
  return [probe createEnd];
}

double 
getDouble (id obj, const char *ivarName)
{
  id probe = makeProbe(obj, ivarName);
  double ret = [probe probeAsDouble: obj];
  [probe drop];
  return ret;
}

int 
getInt(id obj, const char *ivarName)
{
  id probe = makeProbe(obj, ivarName);
  int ret = [probe probeAsInt: obj];
  [probe drop];
  return ret;
}

@implementation MyParameter

+ createBegin: aZone
{
  static struct argp_option options[] = {
    {"inputfile", 'I', "filename",0,"set fn", 5},
    {"run", 'R', "RunNumber",0,"Run is...",6},
    {"seedProb",'p',"seedProb",0,"Seed",7},
    {"worldXSize",'x',"X",0,"Size of X dimension",8},
    {"worldYSize",'y',"Y",0,"Size of Y dimension",9},
    {"numActive",'a',"Active",0,"Number of Active Rules",10},
    {"numAgents",'n',"NA",0,"Number of People",11},
    {"startAttendance",'S',"SA",0,"Initial number of attendees",12},
    {"historyLength",'h',"H",0,"History Length",13},
    {"experimentDuration",'e',"E",0,"Duration of experiment", 14},
    { 0 }
  };
  MyParameter *obj = [super createBegin: aZone];
  [obj addOptions: options];
  
  obj->worldXSize = 100;
  obj->worldYSize = 100;
  obj->historyLength = 20;
  obj->seedProb = 0.5;
  obj->run = 01;
  obj->experimentDuration = 1000;
  obj->numAgents = 100;
  obj->startAttendance = 50;
  obj->numActive = 5;

  return obj;

}

- init
{
  id probeMap;
  probeMap = [EmptyProbeMap createBegin: [self getZone]];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];
  //This stuff is taken fromt eh ModelSwarm.m file
  //Add a bunch of variables, one per simulation parameter.

  [probeMap addProbe: [probeLibrary getProbeForVariable: "worldXSize"
				    inClass:[self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "worldYSize"
				    inClass:[self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "numAgents"
				    inClass:[self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "startAttendance"
				    inClass:[self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "numActive"
				    inClass:[self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "seedProb"
				    inClass:[self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "experimentDuration"
				    inClass:[self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "historyLength"
				    inClass:[self class]]];

//Now install our custom probeMap into the probeLibrary.
 
[probeLibrary setProbeMap: probeMap For: [self class]];
return self;
}

- (int)parseKey: (int) key arg: (const char*) arg
{
  //We could just make a list of if statements that checks the argument
  //to see if it is equal to our parameters, like so:
  //  if (key == 'd')
  //      {
  //          if(arg)
  //          historyLength = strtod (arg,NULL);
  //          return 0;
  //      }
  //Doing that gets a bit tedious, so we use the switch statement from C:
  switch(key)
    {
    case 'p' :
      if(arg)
	seedProb = strtod (arg,NULL);
      break;
    case 'x': 
      if(arg)
	worldXSize = atoi(arg);
      break;
    case 'y':
      if(arg)
	worldYSize = atoi(arg);
      break;
    case 'e':
      if(arg)
	experimentDuration = atoi(arg);
      break;
    case 'h':
      if(arg)
	historyLength = atoi(arg);
      break;
    case 't':
      if(arg)
	startAttendance = atoi(arg);
      break;
    case 'n':
      if(arg)
	numAgents = atoi(arg);
      break;
    case 'a':
      if(arg)
	numActive = atoi(arg);
      break;
    case 'I':
      if(arg)
	//You may need this later
	break;
    case 'R':
      if(arg)
	run = atoi(arg);
      break;
    default:
      return [super parseKey: key arg: arg];
    }
  return 0;
}

@end


