//ObserverSwarm.m
#import <collections.h>
#import <analysis.h>
//#import "Parameters.h"
#import "MyParameter.h"
#import "ObserverSwarm.h"
#import "ModelSwarm.h"
#import <activity.h>
#import <simtoolsgui.h>
#import <simtools.h> //ObjectLoader
#import "EZBar.h"

@implementation ObserverSwarm

//-getParameters { return parameters; }

+createBegin: (id) aZone {
  ObserverSwarm *obj;
  id <ProbeMap> probeMap;
  extern id theObserver;

  // create the observer and parameters objects
  obj = [super createBegin: aZone];
  obj->displayFrequency = 1;
  //obj->parameters = [Parameters createBegin: globalZone];
  obj->drawStratHistogram = 1;
  obj->drawSuccessHistogram = 1;
  // set up the probe into the observer
  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "displayFrequency"
				    inClass: [self class]]];
  [probeLibrary setProbeMap: probeMap For: [self class]];

  theObserver = obj;	// store in global variable theObserver

  return obj;
}

-createEnd {
  return [super createEnd];
}

//-buildObjectsArgC: (int) argc ArgV: (char **) argv  {
-buildObjects {
  //	id modelZone;					  // zone for model.
  id rules;
  [super buildObjects];
  modelSwarm = [ModelSwarm createBegin: self];
  modelSwarm = [modelSwarm createEnd];
    
  //From SOB 3-5. For Agent.scm file.
  //  if ((modelSwarm = 
  //  	     [lispAppArchiver getWithZone: self object: "modelSwarm"])==nil)
  //  	  raiseEvent(InvalidOperation,"Can't find MS Parameters");
  CREATE_ARCHIVED_PROBE_DISPLAY(self);
#ifdef UNATTENDED
  [controlPanel setStateRunning];
#else
  [controlPanel setStateStopped];
#endif
      

  // parameters are all set, build the model objects
  [modelSwarm buildObjects];

  // setup some online displays...
  aGraph = [Graph createBegin: [self getZone]];
  SET_WINDOW_GEOMETRY_RECORD_NAME (aGraph);  // to save window location
  aGraph = [aGraph createEnd];
  [aGraph setTitle: "Attendance (actual,running-avg) vs. time"];
  [aGraph setAxisLabelsX: "Time" Y: "Attendance"];
  [aGraph pack];
  [aGraph setScaleModeX: 1 Y: 0];

  // this is for the current attendance line
  aGraphCurAttendElement = [aGraph createElement];;
  [aGraphCurAttendElement setLabel: "Current Attendance"] ;
  [aGraphCurAttendElement setColor: "black"] ;
  [aGraphCurAttendElement setWidth: 1];
  aGraphCurAttendActiveGraph = [ActiveGraph createBegin: [self getZone]];
  [aGraphCurAttendActiveGraph setElement: aGraphCurAttendElement];

  [aGraphCurAttendActiveGraph setDataFeed: [modelSwarm getTheBar]];
  [aGraphCurAttendActiveGraph setProbedSelector: M(getAttendance)];
  aGraphCurAttendActiveGraph =
    [aGraphCurAttendActiveGraph createEnd];

  // this is for the running average
  aGraphRAvgAttendElement = [aGraph createElement];;
  [aGraphRAvgAttendElement setLabel: "RunAvg Attendance"] ;
  [aGraphRAvgAttendElement  setColor: "red"];
  [aGraphRAvgAttendElement setWidth: 1];
  aGraphRAvgAttendActiveGraph = [ActiveGraph createBegin: [self getZone]];
  [aGraphRAvgAttendActiveGraph setElement: aGraphRAvgAttendElement];

  [aGraphRAvgAttendActiveGraph setDataFeed: [modelSwarm getTheBar]];
  [aGraphRAvgAttendActiveGraph setProbedSelector: M(getRAvgAttendance)];
  aGraphRAvgAttendActiveGraph =
    [aGraphRAvgAttendActiveGraph createEnd];
  rules = [modelSwarm getRules];
  //  if(drawStratHistogram) {
  //  	  stratHistogram = [EZBin createBegin: [self getZone]];
  //  	  SET_WINDOW_GEOMETRY_RECORD_NAME (stratHistogram);
  //  	  [stratHistogram setTitle: "Strategies used"];
  //  	  [stratHistogram setAxisLabelsX: "Strategy" Y: "# of times used"];
  //  	  [stratHistogram setBinCount: 21];
  //  	  [stratHistogram setLowerBound: 0];
  //  	  [stratHistogram setUpperBound: 20];
  //  	  [stratHistogram setCollection: rules];
  //  	  [stratHistogram setProbedSelector: M(getTimesUsed)];
  //  	  stratHistogram = [stratHistogram createEnd];
  //  	  [stratHistogram enableDestroyNotification: self
  //  			  notificationMethod: @selector(_stratHistogramDeath_:)];
  //  	}
  //  	if(drawSuccessHistogram) {
  //  	  successHistogram = [EZBin createBegin: [self getZone]];
  //  	  SET_WINDOW_GEOMETRY_RECORD_NAME (successHistogram);
  //  	  [successHistogram setTitle: "Amount of Success"];
  //  	  [successHistogram setAxisLabelsX: "Strategy" Y: "# of Successes"];
  //  	  [successHistogram setBinCount: 21];
  //  	  [successHistogram setLowerBound: 0];
  //  	  [successHistogram setUpperBound: 20];
  //  	  [successHistogram setCollection: rules];
  //  	  [successHistogram setProbedSelector: M(getTimesSuccess)];
  //  	  successHistogram = [successHistogram createEnd];
  //  	  [successHistogram enableDestroyNotification: self
  //  			  notificationMethod: @selector(_successHistogramDeath_:)];
  //  	}
  stratHistogram = [EZBar createBegin: [self getZone]];
  SET_WINDOW_GEOMETRY_RECORD_NAME (stratHistogram);
  [stratHistogram setTitle: "# of times strategies used"];
  [stratHistogram setAxisLabelsX: "Strategy" Y: "# of times used"];
  [stratHistogram enableDestroyNotification: self
		  notificationMethod: @selector (_stratHistogramDeath_:)];
  [stratHistogram setCollection: [modelSwarm getRules]];
  [stratHistogram setLabelSelector: M(getCharID)];
  [stratHistogram setProbedSelector: M(getTimesUsed)];
  [stratHistogram showCurrent];
  stratHistogram =[stratHistogram createEnd];

  successHistogram = [EZBar createBegin: [self getZone]];
  SET_WINDOW_GEOMETRY_RECORD_NAME (successHistogram);
  [successHistogram setTitle: "# of times strategies are successful"];
  [successHistogram setAxisLabelsX: "Strategy" Y: "# of times successful"];
  [successHistogram enableDestroyNotification: self
		    notificationMethod: @selector (_successHistogramDeath_:)];
  [successHistogram setCollection: [modelSwarm getRules]];
  [successHistogram setLabelSelector: M(getCharID)];
  [successHistogram setProbedSelector: M(getTimesSuccess)];
  [successHistogram showCurrent];
  successHistogram =[successHistogram createEnd];

	
  return self;
}  

-takeScreenShot
{
  id apixmap;
  char filename[40];
  sprintf(filename,"screenRun%03dTime%07ld.png",getInt(arguments,"run"), getCurrentTime());
  [actionCache doTkEvents];
  apixmap= [Pixmap createBegin: self];
  [apixmap setWidget: nil];

  [apixmap  setDecorationsFlag: NO];
  apixmap = [apixmap createEnd]; 
  [apixmap save:filename];
  [apixmap drop];
  return self;
}

-stopRunning
{
  //If compiled with the EXTRACPPFLAG=-DUNATTENDED, a picture will be
  //saved in the current directory.
  if(getCurrentTime() == getInt(arguments,"experimentDuration"))
    {
#ifdef UNATTENDED
      //fist we need a picture
      [self takeScreenShot];
      //This makes the siulationa ctivity stop and Swarm quits.
      [controlPanel setStateQuit];
#else
      //UNATTENDED not defined, so sim just pauses here
      //user intervention with the control panel can start it again.
      [controlPanel setStateStopped];
#endif
    }
  return self;
}

-_stratHistogramDeath_: caller
{
  [stratHistogram drop];
  stratHistogram = nil;
  return self;
}

-_updateStratHistogram_ {
  if(stratHistogram)
    {
      [stratHistogram step];
    }
  if(successHistogram) ; 
  
  return self;
}

-_updateSuccessHistogram_ {
  if(successHistogram)
    {
      [successHistogram step];
    }
  return self;
}

-_successHistogramDeath_: caller
{
  [successHistogram drop];
  successHistogram = nil;
  return self;
}



-buildActions {
  [super buildActions];
  
  [modelSwarm buildActions];
  
  // create actions to the graphs elements to take their steps
  displayActions = [ActionGroup create: [self getZone]];
  [displayActions createActionTo: aGraphCurAttendActiveGraph message: M(step)];
  [displayActions createActionTo: aGraphRAvgAttendActiveGraph message: M(step)];
  if(drawStratHistogram)
    [displayActions createActionTo: self message: M(_updateStratHistogram_)];
  if(drawSuccessHistogram)
    [displayActions createActionTo: self message: M(_updateSuccessHistogram_)];
  // Schedule the update of the probe displays
  [displayActions createActionTo: probeDisplayManager message: M(update)];
  // Finally, schedule an update for the whole user interface code.
  // This is crucial: without this, no graphics update and the control
  // panel will be dead. It's best to put it at the end of the display schedule
  [displayActions createActionTo: actionCache        message: M(doTkEvents)];

  // schedule the actions, starting at 0, at specified frequency
  displaySchedule = [Schedule createBegin: [self getZone]];
  [displaySchedule setRepeatInterval: displayFrequency];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];
  //From SOB 3-5
  stopSchedule = [Schedule createBegin: [self getZone]];
  [stopSchedule setRepeatInterval: 1];
  stopSchedule = [stopSchedule createEnd];
  [stopSchedule at: 0 createActionTo: self message: M(stopRunning)];

  return self;
}  

// boilerplate -- not need to change for simple models
-activateIn: (id) swarmContext {
  [super activateIn: swarmContext];
  [modelSwarm activateIn: self];
  [displaySchedule activateIn: self];
  //SOB 3-5
  [stopSchedule activateIn: self];
  return [self getSwarmActivity];
}

@end



